/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.content.Context;
import com.urbanairship.android.layout.environment.ModelEnvironment;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.info.LinearLayoutInfo;
import com.urbanairship.android.layout.info.LinearLayoutItemInfo;
import com.urbanairship.android.layout.info.VisibilityInfo;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ModelProperties;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.Direction;
import com.urbanairship.android.layout.property.EnableBehaviorType;
import com.urbanairship.android.layout.property.EventHandler;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.view.LinearLayoutView;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B-\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBs\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0007\u0012\u0006\u0010\u001a\u001a\u00020\n\u0012\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lcom/urbanairship/android/layout/model/LinearLayoutModel;", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/view/LinearLayoutView;", "Lcom/urbanairship/android/layout/model/BaseModel$Listener;", "info", "Lcom/urbanairship/android/layout/info/LinearLayoutInfo;", "items", "", "Lcom/urbanairship/android/layout/model/LinearLayoutModel$Item;", "env", "Lcom/urbanairship/android/layout/environment/ModelEnvironment;", "props", "Lcom/urbanairship/android/layout/model/ModelProperties;", "(Lcom/urbanairship/android/layout/info/LinearLayoutInfo;Ljava/util/List;Lcom/urbanairship/android/layout/environment/ModelEnvironment;Lcom/urbanairship/android/layout/model/ModelProperties;)V", "direction", "Lcom/urbanairship/android/layout/property/Direction;", "backgroundColor", "Lcom/urbanairship/android/layout/property/Color;", "border", "Lcom/urbanairship/android/layout/property/Border;", "visibility", "Lcom/urbanairship/android/layout/info/VisibilityInfo;", "eventHandlers", "Lcom/urbanairship/android/layout/property/EventHandler;", "enableBehaviors", "Lcom/urbanairship/android/layout/property/EnableBehaviorType;", "environment", "properties", "(Ljava/util/List;Lcom/urbanairship/android/layout/property/Direction;Lcom/urbanairship/android/layout/property/Color;Lcom/urbanairship/android/layout/property/Border;Lcom/urbanairship/android/layout/info/VisibilityInfo;Ljava/util/List;Ljava/util/List;Lcom/urbanairship/android/layout/environment/ModelEnvironment;Lcom/urbanairship/android/layout/model/ModelProperties;)V", "getDirection", "()Lcom/urbanairship/android/layout/property/Direction;", "getItems", "()Ljava/util/List;", "onCreateView", "context", "Landroid/content/Context;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "Item", "urbanairship-layout_release"})
public final class LinearLayoutModel
extends BaseModel<LinearLayoutView, BaseModel.Listener> {
    @NotNull
    private final List<Item> items;
    @NotNull
    private final Direction direction;

    public LinearLayoutModel(@NotNull List<Item> items, @NotNull Direction direction, @Nullable Color backgroundColor, @Nullable Border border, @Nullable VisibilityInfo visibility, @Nullable List<EventHandler> eventHandlers, @Nullable List<? extends EnableBehaviorType> enableBehaviors, @NotNull ModelEnvironment environment, @NotNull ModelProperties properties) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(ViewType.LINEAR_LAYOUT, backgroundColor, border, visibility, eventHandlers, enableBehaviors, environment, properties);
        this.items = items;
        this.direction = direction;
    }

    public /* synthetic */ LinearLayoutModel(List list, Direction direction, Color color, Border border, VisibilityInfo visibilityInfo, List list2, List list3, ModelEnvironment modelEnvironment, ModelProperties modelProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            color = null;
        }
        if ((n & 8) != 0) {
            border = null;
        }
        if ((n & 0x10) != 0) {
            visibilityInfo = null;
        }
        if ((n & 0x20) != 0) {
            list2 = null;
        }
        if ((n & 0x40) != 0) {
            list3 = null;
        }
        this(list, direction, color, border, visibilityInfo, list2, list3, modelEnvironment, modelProperties);
    }

    @NotNull
    public final List<Item> getItems() {
        return this.items;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public LinearLayoutModel(@NotNull LinearLayoutInfo info, @NotNull List<Item> items, @NotNull ModelEnvironment env, @NotNull ModelProperties props) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        this(items, info.getDirection(), info.getBackgroundColor(), info.getBorder(), info.getVisibility(), info.getEventHandlers(), info.getEnableBehaviors(), env, props);
    }

    @Override
    @NotNull
    protected LinearLayoutView onCreateView(@NotNull Context context, @NotNull ViewEnvironment viewEnvironment) {
        LinearLayoutView linearLayoutView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        LinearLayoutView $this$onCreateView_u24lambda_u2d0 = linearLayoutView = new LinearLayoutView(context, this, viewEnvironment);
        boolean bl = false;
        $this$onCreateView_u24lambda_u2d0.setId(this.getViewId());
        return linearLayoutView;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/urbanairship/android/layout/model/LinearLayoutModel$Item;", "", "info", "Lcom/urbanairship/android/layout/info/LinearLayoutItemInfo;", "model", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/model/AnyModel;", "(Lcom/urbanairship/android/layout/info/LinearLayoutItemInfo;Lcom/urbanairship/android/layout/model/BaseModel;)V", "getInfo", "()Lcom/urbanairship/android/layout/info/LinearLayoutItemInfo;", "getModel", "()Lcom/urbanairship/android/layout/model/BaseModel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "urbanairship-layout_release"})
    public static final class Item {
        @NotNull
        private final LinearLayoutItemInfo info;
        @NotNull
        private final BaseModel<?, ?> model;

        public Item(@NotNull LinearLayoutItemInfo info, @NotNull BaseModel<?, ?> model) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(model, (String)"model");
            this.info = info;
            this.model = model;
        }

        @NotNull
        public final LinearLayoutItemInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final BaseModel<?, ?> getModel() {
            return this.model;
        }

        @NotNull
        public final LinearLayoutItemInfo component1() {
            return this.info;
        }

        @NotNull
        public final BaseModel<?, ?> component2() {
            return this.model;
        }

        @NotNull
        public final Item copy(@NotNull LinearLayoutItemInfo info, @NotNull BaseModel<?, ?> model) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(model, (String)"model");
            return new Item(info, model);
        }

        public static /* synthetic */ Item copy$default(Item item, LinearLayoutItemInfo linearLayoutItemInfo, BaseModel baseModel, int n, Object object) {
            if ((n & 1) != 0) {
                linearLayoutItemInfo = item.info;
            }
            if ((n & 2) != 0) {
                baseModel = item.model;
            }
            return item.copy(linearLayoutItemInfo, baseModel);
        }

        @NotNull
        public String toString() {
            return "Item(info=" + this.info + ", model=" + this.model + ')';
        }

        public int hashCode() {
            int result = this.info.hashCode();
            result = result * 31 + this.model.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            if (!Intrinsics.areEqual((Object)this.info, (Object)item.info)) {
                return false;
            }
            return Intrinsics.areEqual(this.model, item.model);
        }
    }
}

