/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ToggleType;
import com.urbanairship.android.layout.shape.Shape;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.ArrayList;
import java.util.List;

public class CheckboxStyle
extends ToggleStyle {
    @NonNull
    private final Bindings bindings;

    public CheckboxStyle(@NonNull Bindings bindings) {
        super(ToggleType.CHECKBOX);
        this.bindings = bindings;
    }

    @NonNull
    public static CheckboxStyle fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap bindingsJson = json.opt("bindings").optMap();
        Bindings bindings = Bindings.fromJson(bindingsJson);
        return new CheckboxStyle(bindings);
    }

    @NonNull
    public Bindings getBindings() {
        return this.bindings;
    }

    public static class Binding {
        @NonNull
        private final List<Shape> shapes;
        @Nullable
        private final Image.Icon icon;

        public Binding(@NonNull List<Shape> shapes, @Nullable Image.Icon icon) {
            this.shapes = shapes;
            this.icon = icon;
        }

        @NonNull
        public static Binding fromJson(@NonNull JsonMap json) throws JsonException {
            JsonList shapesJson = json.opt("shapes").optList();
            JsonMap iconJson = json.opt("icon").optMap();
            ArrayList<Shape> shapes = new ArrayList<Shape>();
            for (int i = 0; i < shapesJson.size(); ++i) {
                JsonMap shapeJson = shapesJson.get(i).optMap();
                Shape shape = Shape.fromJson(shapeJson);
                shapes.add(shape);
            }
            Image.Icon icon = iconJson.isEmpty() ? null : Image.Icon.fromJson(iconJson);
            return new Binding(shapes, icon);
        }

        @NonNull
        public List<Shape> getShapes() {
            return this.shapes;
        }

        @Nullable
        public Image.Icon getIcon() {
            return this.icon;
        }
    }

    public static class Bindings {
        @NonNull
        private final Binding selected;
        @NonNull
        private final Binding unselected;

        Bindings(@NonNull Binding selected, @NonNull Binding unselected) {
            this.selected = selected;
            this.unselected = unselected;
        }

        public static Bindings fromJson(@NonNull JsonMap json) throws JsonException {
            JsonMap selectedJson = json.opt("selected").optMap();
            JsonMap unselectedJson = json.opt("unselected").optMap();
            Binding selected = Binding.fromJson(selectedJson);
            Binding unselected = Binding.fromJson(unselectedJson);
            return new Bindings(selected, unselected);
        }

        @NonNull
        public Binding getSelected() {
            return this.selected;
        }

        @NonNull
        public Binding getUnselected() {
            return this.unselected;
        }
    }
}

