/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import android.content.Context;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.ColorSelector;
import com.urbanairship.android.layout.property.HexColor;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.List;

public class Color {
    @ColorInt
    public static final int TRANSPARENT = 0;
    @ColorInt
    public static final int WHITE = -1;
    private final int defaultColor;
    @NonNull
    private final List<ColorSelector> selectors;

    public Color(int defaultColor, @NonNull List<ColorSelector> selectors) {
        this.defaultColor = defaultColor;
        this.selectors = selectors;
    }

    @NonNull
    public static Color fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap defaultColorJson = json.opt("default").optMap();
        Integer defaultColor = HexColor.fromJson(defaultColorJson);
        if (defaultColor == null) {
            throw new JsonException("Failed to parse color. 'default' may not be null! json = " + json);
        }
        JsonList selectorsJson = json.opt("selectors").optList();
        List<ColorSelector> selectors = ColorSelector.fromJsonList(selectorsJson);
        return new Color(defaultColor, selectors);
    }

    @Nullable
    public static Color fromJsonField(@Nullable JsonMap json, @NonNull String fieldName) throws JsonException {
        if (json == null || json.isEmpty()) {
            return null;
        }
        JsonMap colorJson = json.opt(fieldName).optMap();
        if (colorJson.isEmpty()) {
            return null;
        }
        return Color.fromJson(colorJson);
    }

    public static float alpha(@ColorInt int color2) {
        return android.graphics.Color.alpha((int)color2);
    }

    @ColorInt
    public int resolve(@NonNull Context context) {
        boolean isDarkMode = ResourceUtils.isUiModeNight(context);
        for (ColorSelector selector : this.selectors) {
            if (selector.isDarkMode() != isDarkMode) continue;
            return selector.getColor();
        }
        return this.defaultColor;
    }
}

