/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum PresentationType {
    BANNER("banner"),
    MODAL("modal");

    @NonNull
    private final String value;

    private PresentationType(String value) {
        this.value = value;
    }

    @NonNull
    public static PresentationType from(@NonNull String value) throws JsonException {
        for (PresentationType type : PresentationType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown PresentationType value: " + value);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

