/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.TextAlignment;
import com.urbanairship.android.layout.property.TextStyle;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.ArrayList;
import java.util.List;

public class TextAppearance {
    @NonNull
    private final Color color;
    @Dimension(unit=0)
    private final int fontSize;
    @NonNull
    private final TextAlignment alignment;
    @NonNull
    private final List<TextStyle> textStyles;
    @NonNull
    private final List<String> fontFamilies;

    protected TextAppearance(@NonNull TextAppearance textAppearance) {
        this.color = textAppearance.color;
        this.fontSize = textAppearance.fontSize;
        this.alignment = textAppearance.alignment;
        this.textStyles = textAppearance.textStyles;
        this.fontFamilies = textAppearance.fontFamilies;
    }

    public TextAppearance(@NonNull Color color2, int fontSize, @NonNull TextAlignment alignment, @NonNull List<TextStyle> textStyles, @NonNull List<String> fontFamilies) {
        this.color = color2;
        this.fontSize = fontSize;
        this.alignment = alignment;
        this.textStyles = textStyles;
        this.fontFamilies = fontFamilies;
    }

    @NonNull
    public static TextAppearance fromJson(@NonNull JsonMap json) throws JsonException {
        int fontSize = json.opt("font_size").getInt(14);
        Color color2 = Color.fromJsonField(json, "color");
        if (color2 == null) {
            throw new JsonException("Failed to parse text appearance. 'color' may not be null!");
        }
        String alignmentString = json.opt("alignment").optString();
        JsonList textStylesJson = json.opt("styles").optList();
        JsonList fontFamiliesJson = json.opt("font_families").optList();
        TextAlignment alignment = alignmentString.isEmpty() ? TextAlignment.CENTER : TextAlignment.from(alignmentString);
        ArrayList<TextStyle> textStyles = new ArrayList<TextStyle>();
        for (int i = 0; i < textStylesJson.size(); ++i) {
            String styleString = textStylesJson.get(i).optString();
            TextStyle style = TextStyle.from(styleString);
            textStyles.add(style);
        }
        ArrayList<String> fontFamilies = new ArrayList<String>();
        for (int i = 0; i < fontFamiliesJson.size(); ++i) {
            String fontFamily = fontFamiliesJson.get(i).optString();
            fontFamilies.add(fontFamily);
        }
        return new TextAppearance(color2, fontSize, alignment, textStyles, fontFamilies);
    }

    @NonNull
    public Color getColor() {
        return this.color;
    }

    @Dimension(unit=0)
    public int getFontSize() {
        return this.fontSize;
    }

    @NonNull
    public TextAlignment getAlignment() {
        return this.alignment;
    }

    @NonNull
    public List<TextStyle> getTextStyles() {
        return this.textStyles;
    }

    @NonNull
    public List<String> getFontFamilies() {
        return this.fontFamilies;
    }
}

