/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.shape;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.json.JsonException;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public enum ShapeType {
    RECTANGLE("rectangle", 0),
    ELLIPSE("ellipse", 1);

    @NonNull
    private final String value;
    private final int drawableShape;

    private ShapeType(String value, int drawableShape) {
        this.value = value;
        this.drawableShape = drawableShape;
    }

    @NonNull
    public static ShapeType from(@NonNull String value) throws JsonException {
        for (ShapeType type : ShapeType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown ShapeType value: " + value);
    }

    public int getDrawableShapeType() {
        return this.drawableShape;
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

