/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.core.content.ContextCompat;
import com.urbanairship.UAirship;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.model.ButtonModel;
import com.urbanairship.android.layout.model.ImageButtonModel;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.util.ColorStateListBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.StringExtensionsKt;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.TappableView;
import com.urbanairship.images.ImageRequestOptions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/urbanairship/android/layout/view/ImageButtonView;", "Landroidx/appcompat/widget/AppCompatImageButton;", "Lcom/urbanairship/android/layout/view/BaseView;", "Lcom/urbanairship/android/layout/widget/TappableView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/ImageButtonModel;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/ImageButtonModel;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "visibilityChangeListener", "Lcom/urbanairship/android/layout/view/BaseView$VisibilityChangeListener;", "onVisibilityChanged", "", "changedView", "Landroid/view/View;", "visibility", "", "taps", "Lkotlinx/coroutines/flow/Flow;", "urbanairship-layout_release"})
public final class ImageButtonView
extends AppCompatImageButton
implements BaseView,
TappableView {
    @Nullable
    private BaseView.VisibilityChangeListener visibilityChangeListener;

    public ImageButtonView(@NotNull Context context, @NotNull ImageButtonModel model, @NotNull ViewEnvironment viewEnvironment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        super(context);
        this.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.ua_layout_imagebutton_ripple));
        this.setClickable(true);
        this.setFocusable(true);
        this.setPadding(0, 0, 0, 0);
        this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        LayoutUtils.applyBorderAndBackground((View)this, model);
        StringExtensionsKt.ifNotEmpty(model.getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.setContentDescription(it);
            }
        }));
        Image image = model.getImage();
        switch (WhenMappings.$EnumSwitchMapping$0[image.getType().ordinal()]) {
            case 1: {
                Ref.ObjectRef url = new Ref.ObjectRef();
                Intrinsics.checkNotNull((Object)image, (String)"null cannot be cast to non-null type com.urbanairship.android.layout.property.Image.Url");
                String string = ((Image.Url)image).getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"image as Image.Url).url");
                url.element = string;
                String string2 = viewEnvironment.imageCache().get((String)url.element);
                if (string2 != null) {
                    String cachedImage = string2;
                    boolean bl = false;
                    url.element = cachedImage;
                }
                final Ref.BooleanRef isLoaded = new Ref.BooleanRef();
                ImageButtonView._init_$loadImage(context, this, isLoaded, (String)url.element);
                this.visibilityChangeListener = new BaseView.VisibilityChangeListener((Ref.ObjectRef<String>)url, context, this){
                    final /* synthetic */ Ref.ObjectRef<String> $url;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ ImageButtonView this$0;
                    {
                        this.$url = $url;
                        this.$context = $context;
                        this.this$0 = $receiver;
                    }

                    @Override
                    public void onVisibilityChanged(int visibility) {
                        if (visibility == 0 && !isLoaded.element) {
                            ImageButtonView._init_$loadImage(this.$context, this.this$0, isLoaded, (String)this.$url.element);
                        }
                    }
                };
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)image, (String)"null cannot be cast to non-null type com.urbanairship.android.layout.property.Image.Icon");
                Image.Icon icon = (Image.Icon)image;
                this.setImageDrawable(icon.getDrawable(context));
                int normalColor = icon.getTint().resolve(context);
                int pressedColor = LayoutUtils.generatePressedColor(normalColor);
                int disabledColor = LayoutUtils.generateDisabledColor(normalColor);
                int[] nArray = new int[]{16842919};
                ColorStateListBuilder colorStateListBuilder = new ColorStateListBuilder().add(pressedColor, nArray);
                nArray = new int[]{-16842910};
                this.setImageTintList(colorStateListBuilder.add(disabledColor, nArray).add(normalColor).build());
            }
        }
        model.setListener$urbanairship_layout_release(new ButtonModel.Listener(){

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void dismissSoftKeyboard() {
                LayoutUtils.dismissSoftKeyboard((View)this);
            }
        });
    }

    @Override
    @NotNull
    public Flow<Unit> taps() {
        return ViewExtensionsKt.debouncedClicks$default((View)this, 0L, 1, null);
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
            super.onVisibilityChanged(changedView, visibility);
            BaseView.VisibilityChangeListener visibilityChangeListener = this.visibilityChangeListener;
            if (visibilityChangeListener == null) break block0;
            visibilityChangeListener.onVisibilityChanged(visibility);
        }
    }

    private static final void loadImage$lambda-1(Ref.BooleanRef $isLoaded, boolean success) {
        Intrinsics.checkNotNullParameter((Object)$isLoaded, (String)"$isLoaded");
        if (success) {
            $isLoaded.element = true;
        }
    }

    private static final void _init_$loadImage(Context $context, ImageButtonView this$0, Ref.BooleanRef isLoaded, String url) {
        UAirship.shared().getImageLoader().load($context, (ImageView)this$0, ImageRequestOptions.newBuilder((String)url).setImageLoadedCallback(arg_0 -> ImageButtonView.loadImage$lambda-1(isLoaded, arg_0)).build());
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Image.Type.values().length];
            nArray[Image.Type.URL.ordinal()] = 1;
            nArray[Image.Type.ICON.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

