/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.animation.LayoutTransition;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.info.LinearLayoutItemInfo;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.LinearLayoutModel;
import com.urbanairship.android.layout.property.Direction;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Size;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.WeightlessLinearLayout;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/urbanairship/android/layout/view/LinearLayoutView;", "Lcom/urbanairship/android/layout/widget/WeightlessLinearLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/LinearLayoutModel;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/LinearLayoutModel;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "addItems", "", "items", "", "Lcom/urbanairship/android/layout/model/LinearLayoutModel$Item;", "generateItemLayoutParams", "Lcom/urbanairship/android/layout/widget/WeightlessLinearLayout$LayoutParams;", "itemInfo", "Lcom/urbanairship/android/layout/info/LinearLayoutItemInfo;", "urbanairship-layout_release"})
public final class LinearLayoutView
extends WeightlessLinearLayout
implements BaseView {
    @NotNull
    private final ViewEnvironment viewEnvironment;

    /*
     * WARNING - void declaration
     */
    public LinearLayoutView(@NotNull Context context, @NotNull LinearLayoutModel model, @NotNull ViewEnvironment viewEnvironment) {
        void $this$_init__u24lambda_u2d0;
        LayoutTransition layoutTransition;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        super(context);
        this.viewEnvironment = viewEnvironment;
        this.setClipChildren(false);
        LayoutUtils.applyBorderAndBackground((View)this, model);
        this.setOrientation(model.getDirection() == Direction.VERTICAL ? 1 : 0);
        this.setGravity(model.getDirection() == Direction.VERTICAL ? 1 : 16);
        this.addItems(model.getItems());
        model.setListener$urbanairship_layout_release((BaseModel.Listener)new BaseModel.Listener(){

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }
        });
        LayoutTransition layoutTransition2 = layoutTransition = new LayoutTransition();
        LinearLayoutView linearLayoutView = this;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.disableTransitionType(2);
        linearLayoutView.setLayoutTransition(layoutTransition);
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (arg_0, arg_1) -> LinearLayoutView._init_$lambda-1(this, arg_0, arg_1));
    }

    private final void addItems(List<LinearLayoutModel.Item> items) {
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            Object obj;
            LinearLayoutModel.Item item = items.get(i);
            LinearLayoutItemInfo itemInfo = item.component1();
            BaseModel<?, ?> itemModel = item.component2();
            WeightlessLinearLayout.LayoutParams lp = this.generateItemLayoutParams(itemInfo);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Object $this$addItems_u24lambda_u2d2 = obj = itemModel.createView(context, this.viewEnvironment);
            boolean bl = false;
            $this$addItems_u24lambda_u2d2.setLayoutParams((ViewGroup.LayoutParams)lp);
            Object itemView = obj;
            this.addViewInLayout((View)itemView, -1, (ViewGroup.LayoutParams)lp, true);
        }
    }

    private final WeightlessLinearLayout.LayoutParams generateItemLayoutParams(LinearLayoutItemInfo itemInfo) {
        WeightlessLinearLayout.LayoutParams layoutParams;
        Pair pair;
        Pair pair2;
        Size size = itemInfo.getSize();
        Size.Dimension dimension = size.getWidth();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"size.width");
        Size.Dimension w = dimension;
        Size.Dimension dimension2 = size.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"size.height");
        Size.Dimension h = dimension2;
        switch (WhenMappings.$EnumSwitchMapping$0[w.getType().ordinal()]) {
            case 1: {
                pair2 = TuplesKt.to((Object)-2, (Object)Float.valueOf(0.0f));
                break;
            }
            case 2: {
                pair2 = TuplesKt.to((Object)((int)ResourceUtils.dpToPx(this.getContext(), w.getInt())), (Object)Float.valueOf(0.0f));
                break;
            }
            case 3: {
                pair2 = TuplesKt.to((Object)0, (Object)Float.valueOf(w.getFloat()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair3 = pair2;
        int width = ((Number)pair3.component1()).intValue();
        float maxWidthPercent = ((Number)pair3.component2()).floatValue();
        switch (WhenMappings.$EnumSwitchMapping$0[h.getType().ordinal()]) {
            case 1: {
                pair = TuplesKt.to((Object)-2, (Object)Float.valueOf(0.0f));
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)((int)ResourceUtils.dpToPx(this.getContext(), h.getInt())), (Object)Float.valueOf(0.0f));
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)0, (Object)Float.valueOf(h.getFloat()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair4 = pair;
        int height = ((Number)pair4.component1()).intValue();
        float maxHeightPercent = ((Number)pair4.component2()).floatValue();
        WeightlessLinearLayout.LayoutParams $this$generateItemLayoutParams_u24lambda_u2d4 = layoutParams = new WeightlessLinearLayout.LayoutParams(width, height, maxWidthPercent, maxHeightPercent);
        boolean bl = false;
        Margin margin = itemInfo.getMargin();
        if (margin != null) {
            Margin margin2 = margin;
            boolean bl2 = false;
            $this$generateItemLayoutParams_u24lambda_u2d4.topMargin = (int)ResourceUtils.dpToPx(this.getContext(), margin2.getTop());
            $this$generateItemLayoutParams_u24lambda_u2d4.bottomMargin = (int)ResourceUtils.dpToPx(this.getContext(), margin2.getBottom());
            $this$generateItemLayoutParams_u24lambda_u2d4.setMarginStart((int)ResourceUtils.dpToPx(this.getContext(), margin2.getStart()));
            $this$generateItemLayoutParams_u24lambda_u2d4.setMarginEnd((int)ResourceUtils.dpToPx(this.getContext(), margin2.getEnd()));
        }
        WeightlessLinearLayout.LayoutParams lp = layoutParams;
        return lp;
    }

    private static final WindowInsetsCompat _init_$lambda-1(LinearLayoutView this$0, View view, WindowInsetsCompat windowInsetsCompat) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)view, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)windowInsetsCompat, (String)"<anonymous parameter 1>");
        WindowInsetsCompat windowInsetsCompat2 = new WindowInsetsCompat.Builder().setInsets(WindowInsetsCompat.Type.systemBars(), Insets.NONE).build();
        Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"Builder()\n              \u2026\n                .build()");
        WindowInsetsCompat noInsets = windowInsetsCompat2;
        int n = this$0.getChildCount();
        for (int i = 0; i < n; ++i) {
            ViewCompat.dispatchApplyWindowInsets((View)this$0.getChildAt(i), (WindowInsetsCompat)noInsets);
        }
        return noInsets;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Size.DimensionType.values().length];
            nArray[Size.DimensionType.AUTO.ordinal()] = 1;
            nArray[Size.DimensionType.ABSOLUTE.ordinal()] = 2;
            nArray[Size.DimensionType.PERCENT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

