/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Dimension;
import androidx.appcompat.widget.SwitchCompat;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.CheckableModel;
import com.urbanairship.android.layout.property.CheckboxStyle;
import com.urbanairship.android.layout.property.SwitchStyle;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ToggleType;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.util.StringExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.CheckableViewAdapter;
import com.urbanairship.android.layout.widget.ShapeButton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b \u0018\u0000 0*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u00032\u00020\u0004:\u00010B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020#H\u0014J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0016H\u0014J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0004J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020-H\u0016R\u001e\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0016\u0010\u0007\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lcom/urbanairship/android/layout/widget/CheckableView;", "M", "Lcom/urbanairship/android/layout/model/CheckableModel;", "Landroid/widget/FrameLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "context", "Landroid/content/Context;", "model", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/CheckableModel;)V", "checkableView", "Lcom/urbanairship/android/layout/widget/CheckableViewAdapter;", "getCheckableView", "()Lcom/urbanairship/android/layout/widget/CheckableViewAdapter;", "setCheckableView", "(Lcom/urbanairship/android/layout/widget/CheckableViewAdapter;)V", "checkedChangeListener", "Lcom/urbanairship/android/layout/widget/CheckableViewAdapter$OnCheckedChangeListener;", "getCheckedChangeListener", "()Lcom/urbanairship/android/layout/widget/CheckableViewAdapter$OnCheckedChangeListener;", "setCheckedChangeListener", "(Lcom/urbanairship/android/layout/widget/CheckableViewAdapter$OnCheckedChangeListener;)V", "minHeight", "", "getMinHeight", "()I", "minWidth", "getMinWidth", "getModel", "()Lcom/urbanairship/android/layout/model/CheckableModel;", "Lcom/urbanairship/android/layout/model/CheckableModel;", "configureCheckbox", "", "style", "Lcom/urbanairship/android/layout/property/CheckboxStyle;", "configureSwitch", "Lcom/urbanairship/android/layout/property/SwitchStyle;", "createCheckboxView", "Lcom/urbanairship/android/layout/widget/ShapeButton;", "createSwitchView", "Landroidx/appcompat/widget/SwitchCompat;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setCheckedInternal", "isChecked", "", "setEnabled", "isEnabled", "Companion", "urbanairship-layout_release"})
public abstract class CheckableView<M extends CheckableModel<?>>
extends FrameLayout
implements BaseView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final M model;
    @Nullable
    private CheckableViewAdapter.OnCheckedChangeListener checkedChangeListener;
    public CheckableViewAdapter<?> checkableView;
    @Dimension(unit=0)
    private static final int CHECKBOX_MIN_DIMENSION = 24;
    @Dimension(unit=0)
    private static final int SWITCH_MIN_HEIGHT = 24;
    @Dimension(unit=0)
    private static final int SWITCH_MIN_WIDTH = 48;
    private static final int NO_MIN_SIZE = -1;

    public CheckableView(@NotNull Context context, @NotNull M model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super(context);
        this.model = model;
        switch (WhenMappings.$EnumSwitchMapping$0[((CheckableModel)this.model).getToggleType().ordinal()]) {
            case 1: {
                ToggleStyle toggleStyle = ((CheckableModel)this.model).getStyle();
                Intrinsics.checkNotNull((Object)toggleStyle, (String)"null cannot be cast to non-null type com.urbanairship.android.layout.property.SwitchStyle");
                this.configureSwitch((SwitchStyle)toggleStyle);
                break;
            }
            case 2: {
                ToggleStyle toggleStyle = ((CheckableModel)this.model).getStyle();
                Intrinsics.checkNotNull((Object)toggleStyle, (String)"null cannot be cast to non-null type com.urbanairship.android.layout.property.CheckboxStyle");
                this.configureCheckbox((CheckboxStyle)toggleStyle);
            }
        }
        LayoutUtils.applyBorderAndBackground((View)this, (BaseModel)this.model);
        StringExtensionsKt.ifNotEmpty(((CheckableModel)this.model).getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getCheckableView().setContentDescription(it);
            }
        }));
    }

    @NotNull
    protected final M getModel() {
        return this.model;
    }

    @Nullable
    public final CheckableViewAdapter.OnCheckedChangeListener getCheckedChangeListener() {
        return this.checkedChangeListener;
    }

    public final void setCheckedChangeListener(@Nullable CheckableViewAdapter.OnCheckedChangeListener onCheckedChangeListener) {
        this.checkedChangeListener = onCheckedChangeListener;
    }

    @NotNull
    public final CheckableViewAdapter<?> getCheckableView() {
        CheckableViewAdapter<?> checkableViewAdapter = this.checkableView;
        if (checkableViewAdapter != null) {
            return checkableViewAdapter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"checkableView");
        return null;
    }

    public final void setCheckableView(@NotNull CheckableViewAdapter<?> checkableViewAdapter) {
        Intrinsics.checkNotNullParameter(checkableViewAdapter, (String)"<set-?>");
        this.checkableView = checkableViewAdapter;
    }

    private final int getMinWidth() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[((CheckableModel)this.model).getToggleType().ordinal()]) {
            case 2: {
                n = 24;
                break;
            }
            case 1: {
                n = 48;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int getMinHeight() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[((CheckableModel)this.model).getToggleType().ordinal()]) {
            case 2: {
                n = 24;
                break;
            }
            case 1: {
                n = 24;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidthDp = this.getMinWidth();
        int minHeightDp = this.getMinHeight();
        if (minWidthDp == -1 && minHeightDp == -1) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int widthSpec = widthMeasureSpec;
            int heightSpec = heightMeasureSpec;
            if (minWidthDp != -1) {
                int minWidth = (int)ResourceUtils.dpToPx(this.getContext(), minWidthDp);
                if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
                    widthSpec = View.MeasureSpec.makeMeasureSpec((int)minWidth, (int)0x40000000);
                }
            }
            if (minHeightDp != -1) {
                int minHeight = (int)ResourceUtils.dpToPx(this.getContext(), minHeightDp);
                if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)minHeight, (int)0x40000000);
                }
            }
            super.onMeasure(widthSpec, heightSpec);
        }
    }

    private final void configureSwitch(SwitchStyle style) {
        FrameLayout.LayoutParams layoutParams;
        SwitchCompat switchView = this.createSwitchView(style);
        switchView.setId(((CheckableModel)this.model).getCheckableViewId());
        LayoutUtils.applySwitchStyle(switchView, style);
        this.setCheckableView(new CheckableViewAdapter.Switch(switchView));
        FrameLayout.LayoutParams $this$configureSwitch_u24lambda_u2d0 = layoutParams = new FrameLayout.LayoutParams(-1, -1);
        boolean bl = false;
        $this$configureSwitch_u24lambda_u2d0.topMargin = -3;
        FrameLayout.LayoutParams lp = layoutParams;
        this.addView((View)switchView, (ViewGroup.LayoutParams)lp);
    }

    private final void configureCheckbox(CheckboxStyle style) {
        ShapeButton checkboxView = this.createCheckboxView(style);
        checkboxView.setId(((CheckableModel)this.model).getCheckableViewId());
        LayoutUtils.applyBorderAndBackground((View)checkboxView, (BaseModel)this.model);
        this.setCheckableView(new CheckableViewAdapter.Checkbox(checkboxView));
        this.addView((View)checkboxView, -1, -1);
    }

    @NotNull
    protected SwitchCompat createSwitchView(@NotNull SwitchStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new SwitchCompat(this.getContext());
    }

    @NotNull
    protected ShapeButton createCheckboxView(@NotNull CheckboxStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        CheckboxStyle.Binding binding = style.getBindings().getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)binding, (String)"style.bindings.selected");
        CheckboxStyle.Binding checked = binding;
        CheckboxStyle.Binding binding2 = style.getBindings().getUnselected();
        Intrinsics.checkNotNullExpressionValue((Object)binding2, (String)"style.bindings.unselected");
        CheckboxStyle.Binding unchecked = binding2;
        return new ShapeButton(this.getContext(), checked.getShapes(), unchecked.getShapes(), checked.getIcon(), unchecked.getIcon());
    }

    protected final void setCheckedInternal(boolean isChecked) {
        this.getCheckableView().setOnCheckedChangeListener(null);
        this.getCheckableView().setChecked(isChecked);
        this.getCheckableView().setOnCheckedChangeListener(this.checkedChangeListener);
    }

    public void setEnabled(boolean isEnabled) {
        this.getCheckableView().setEnabled(isEnabled);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/urbanairship/android/layout/widget/CheckableView$Companion;", "", "()V", "CHECKBOX_MIN_DIMENSION", "", "NO_MIN_SIZE", "SWITCH_MIN_HEIGHT", "SWITCH_MIN_WIDTH", "urbanairship-layout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToggleType.values().length];
            nArray[ToggleType.SWITCH.ordinal()] = 1;
            nArray[ToggleType.CHECKBOX.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

