/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import com.urbanairship.android.layout.widget.ShapeButton;

public abstract class CheckableViewAdapter<V extends View> {
    protected final V view;

    private CheckableViewAdapter(@NonNull V view) {
        this.view = view;
    }

    public abstract void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener var1);

    public abstract void setChecked(boolean var1);

    public abstract void setEnabled(boolean var1);

    public abstract boolean isChecked();

    public void setContentDescription(@NonNull String contentDescription) {
        this.view.setContentDescription((CharSequence)contentDescription);
    }

    public void setId(@IdRes int id) {
        this.view.setId(id);
    }

    /* synthetic */ CheckableViewAdapter(View x0, 1 x1) {
        this(x0);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChange(View var1, boolean var2);
    }

    public static class Switch
    extends CheckableViewAdapter<SwitchCompat> {
        public Switch(@NonNull SwitchCompat view) {
            super((View)view, null);
        }

        @Override
        public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener2) {
            ((SwitchCompat)this.view).setOnCheckedChangeListener(listener2 != null ? listener2::onCheckedChange : null);
        }

        @Override
        public void setChecked(boolean isChecked) {
            ((SwitchCompat)this.view).setChecked(isChecked);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            ((SwitchCompat)this.view).setEnabled(isEnabled);
        }

        @Override
        public boolean isChecked() {
            return ((SwitchCompat)this.view).isChecked();
        }
    }

    public static class Checkbox
    extends CheckableViewAdapter<ShapeButton> {
        public Checkbox(@NonNull ShapeButton view) {
            super((View)view, null);
        }

        @Override
        public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener2) {
            ((ShapeButton)this.view).setOnCheckedChangeListener(listener2 != null ? listener2::onCheckedChange : null);
        }

        @Override
        public void setChecked(boolean isChecked) {
            ((ShapeButton)this.view).setChecked(isChecked);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            ((ShapeButton)this.view).setEnabled(isEnabled);
        }

        @Override
        public boolean isChecked() {
            return ((ShapeButton)this.view).isChecked();
        }
    }
}

