/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PagerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NonNull
    private final List<BaseModel<?, ?>> items = new ArrayList();
    @NonNull
    private final PagerModel pagerModel;
    @NonNull
    private final ViewEnvironment viewEnvironment;

    public PagerAdapter(@NonNull PagerModel model, @NonNull ViewEnvironment viewEnvironment) {
        this.pagerModel = model;
        this.viewEnvironment = viewEnvironment;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(parent.getContext());
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        BaseModel<?, ?> model = this.getItemAtPosition(position);
        holder.container.setId(this.pagerModel.getPageViewId(position));
        holder.bind(model, this.viewEnvironment);
    }

    public void onViewRecycled(@NonNull ViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onRecycled();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        return this.items.get(position).getViewType().ordinal();
    }

    public BaseModel<?, ?> getItemAtPosition(int position) {
        return this.items.get(position);
    }

    public void setItems(@NonNull List<BaseModel<?, ?>> items) {
        if (!this.items.equals(items)) {
            this.items.clear();
            this.items.addAll(items);
            this.notifyDataSetChanged();
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final ViewGroup container;

        public ViewHolder(@NonNull Context context) {
            this((ViewGroup)new FrameLayout(context));
        }

        private ViewHolder(@NonNull ViewGroup container) {
            super((View)container);
            this.container = container;
        }

        public void bind(@NonNull BaseModel<?, ?> item, @NonNull ViewEnvironment viewEnvironment) {
            Object view = item.createView(this.itemView.getContext(), viewEnvironment);
            this.container.addView(view, -1, -1);
            LayoutUtils.doOnAttachToWindow(this.itemView, () -> ViewCompat.requestApplyInsets((View)this.itemView));
        }

        public void onRecycled() {
            this.container.removeAllViews();
        }
    }
}

