/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.android.layout.view.PagerView;
import com.urbanairship.android.layout.widget.PagerAdapter;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PagerRecyclerView
extends RecyclerView {
    private final PagerModel model;
    private final ViewEnvironment viewEnvironment;
    private PagerAdapter adapter;
    private LinearLayoutManager layoutManager;
    private PagerSnapHelper snapHelper;
    private boolean isInternalScroll = false;
    @Nullable
    private PagerView.OnScrollListener listener = null;
    private final RecyclerView.OnScrollListener recyclerScrollListener = new RecyclerView.OnScrollListener(){
        private int previousPosition = 0;

        public void onScrollStateChanged(@NonNull RecyclerView v, int state) {
            int position = PagerRecyclerView.this.getDisplayedItemPosition();
            if (position != -1 && position != this.previousPosition) {
                int step = position > this.previousPosition ? 1 : -1;
                int distance = Math.abs(position - this.previousPosition);
                for (int i = 0; i < distance; ++i) {
                    int calculated = this.previousPosition + step * (i + 1);
                    if (PagerRecyclerView.this.listener == null) continue;
                    PagerRecyclerView.this.listener.onScrollTo(calculated, PagerRecyclerView.this.isInternalScroll);
                }
            }
            this.previousPosition = position;
            if (state == 0) {
                PagerRecyclerView.this.isInternalScroll = false;
            }
        }
    };

    public PagerRecyclerView(@NonNull Context context, @NonNull PagerModel model, @NonNull ViewEnvironment viewEnvironment) {
        super(context);
        this.model = model;
        this.viewEnvironment = viewEnvironment;
        this.setId(model.getRecyclerViewId());
        this.configure();
    }

    public void configure() {
        this.setHorizontalScrollBarEnabled(false);
        this.snapHelper = new SnapHelper();
        this.snapHelper.attachToRecyclerView((RecyclerView)this);
        this.layoutManager = this.model.getPages().size() <= 1 || this.model.isSwipeDisabled() ? new SwipeDisabledLinearLayoutManager(this.getContext(), 0) : new ThomasLinearLayoutManager(this.getContext(), 0);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.addOnScrollListener(this.recyclerScrollListener);
        this.adapter = new PagerAdapter(this.model, this.viewEnvironment);
        this.adapter.setStateRestorationPolicy(RecyclerView.Adapter.StateRestorationPolicy.PREVENT_WHEN_EMPTY);
        this.adapter.setItems(this.model.getPages());
        this.setAdapter(this.adapter);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (v, insets) -> {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewCompat.dispatchApplyWindowInsets((View)this.getChildAt(i), (WindowInsetsCompat)insets);
            }
            return insets;
        });
    }

    public int getDisplayedItemPosition() {
        View snapView = this.snapHelper.findSnapView((RecyclerView.LayoutManager)this.layoutManager);
        return snapView != null ? this.getChildAdapterPosition(snapView) : 0;
    }

    public void scrollTo(int position) {
        this.isInternalScroll = true;
        this.smoothScrollToPosition(position);
    }

    public void setPagerScrollListener(@Nullable PagerView.OnScrollListener listener2) {
        this.listener = listener2;
    }

    private static class SnapHelper
    extends PagerSnapHelper {
        @Nullable
        private OrientationHelper verticalHelper;
        @Nullable
        private OrientationHelper horizontalHelper;

        private SnapHelper() {
        }

        @Nullable
        public View findSnapView(RecyclerView.LayoutManager layoutManager) {
            if (layoutManager.getLayoutDirection() == 1) {
                return this.findCenterView(layoutManager, this.getVerticalHelper(layoutManager));
            }
            return this.findCenterView(layoutManager, this.getHorizontalHelper(layoutManager));
        }

        @Nullable
        private View findCenterView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
            int childCount = layoutManager.getChildCount();
            if (childCount == 0) {
                return null;
            }
            View closestChild = null;
            int center = helper.getStartAfterPadding() + helper.getTotalSpace() / 2;
            int absClosest = Integer.MAX_VALUE;
            for (int i = 0; i < childCount; ++i) {
                View child = layoutManager.getChildAt(i);
                int childCenter = helper.getDecoratedStart(child) + helper.getDecoratedMeasurement(child) / 2;
                int absDistance = Math.abs(childCenter - center);
                if (absDistance >= absClosest) continue;
                absClosest = absDistance;
                closestChild = child;
            }
            return closestChild;
        }

        @NonNull
        private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
            if (this.verticalHelper == null || this.verticalHelper.getLayoutManager() != layoutManager) {
                this.verticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
            }
            return this.verticalHelper;
        }

        @NonNull
        private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
            if (this.horizontalHelper == null || this.horizontalHelper.getLayoutManager() != layoutManager) {
                this.horizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
            }
            return this.horizontalHelper;
        }
    }

    private static class SwipeDisabledLinearLayoutManager
    extends ThomasLinearLayoutManager {
        public SwipeDisabledLinearLayoutManager(Context context, int orientation) {
            super(context, orientation);
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            SwipeDisabledSmoothScroller smoothScroller = new SwipeDisabledSmoothScroller(recyclerView.getContext());
            smoothScroller.setTargetPosition(position);
            this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
        }

        private static class SwipeDisabledSmoothScroller
        extends LinearSmoothScroller {
            public SwipeDisabledSmoothScroller(Context context) {
                super(context);
            }

            public int calculateDxToMakeVisible(View view, int snapPreference) {
                RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
                if (layoutManager == null) {
                    return 0;
                }
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                int left = layoutManager.getDecoratedLeft(view) - params.leftMargin;
                int right = layoutManager.getDecoratedRight(view) + params.rightMargin;
                int start = layoutManager.getPaddingLeft();
                int end = layoutManager.getWidth() - layoutManager.getPaddingRight();
                return this.calculateDtToFit(left, right, start, end, snapPreference);
            }
        }
    }

    private static class ThomasLinearLayoutManager
    extends LinearLayoutManager {
        public ThomasLinearLayoutManager(Context context, int orientation) {
            super(context, orientation, false);
            this.setItemPrefetchEnabled(false);
        }

        public RecyclerView.LayoutParams generateDefaultLayoutParams() {
            return new RecyclerView.LayoutParams(-1, -1);
        }
    }
}

