/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.annotation.Dimension;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.content.ContextCompat;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.property.TextAppearance;
import com.urbanairship.android.layout.shape.Shape;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.widget.Clippable;
import com.urbanairship.android.layout.widget.ClippableViewDelegate;
import java.util.List;

public class ShapeButton
extends AppCompatButton
implements Checkable,
Clippable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    @Nullable
    private final TextAppearance checkedTextAppearance;
    @Nullable
    private final TextAppearance uncheckedTextAppearance;
    @Nullable
    private final String text;
    private final ClippableViewDelegate clippableViewDelegate;
    private boolean isChecked = false;
    @Nullable
    private OnCheckedChangeListener checkedChangeListener = null;

    public ShapeButton(@NonNull Context context, @NonNull List<Shape> checkedShapes, @NonNull List<Shape> uncheckedShapes, @Nullable String text, @Nullable TextAppearance checkedTextAppearance, @Nullable TextAppearance uncheckedTextAppearance) {
        this(context, checkedShapes, uncheckedShapes, null, null, text, checkedTextAppearance, uncheckedTextAppearance);
    }

    public ShapeButton(@NonNull Context context, @NonNull List<Shape> checkedShapes, @NonNull List<Shape> uncheckedShapes, @Nullable Image.Icon checkedIcon, @Nullable Image.Icon uncheckedIcon) {
        this(context, checkedShapes, uncheckedShapes, checkedIcon, uncheckedIcon, null, null, null);
    }

    public ShapeButton(@NonNull Context context, @NonNull List<Shape> checkedShapes, @NonNull List<Shape> uncheckedShapes, @Nullable Image.Icon checkedIcon, @Nullable Image.Icon uncheckedIcon, @Nullable String text, @Nullable TextAppearance checkedTextAppearance, @Nullable TextAppearance uncheckedTextAppearance) {
        super(context);
        this.checkedTextAppearance = checkedTextAppearance;
        this.uncheckedTextAppearance = uncheckedTextAppearance;
        this.text = text;
        this.clippableViewDelegate = new ClippableViewDelegate();
        StateListDrawable background = Shape.buildStateListDrawable(context, checkedShapes, uncheckedShapes, checkedIcon, uncheckedIcon);
        this.setBackground((Drawable)background);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setForeground(ContextCompat.getDrawable((Context)context, (int)R.drawable.ua_layout_imagebutton_ripple));
        }
        this.setText(text);
        this.updateText();
        this.setPadding(0, 0, 0, 0);
        this.setGravity(17);
    }

    public void setChecked(boolean checked) {
        if (checked != this.isChecked) {
            this.isChecked = checked;
            this.refreshDrawableState();
            this.updateText();
            if (this.checkedChangeListener != null) {
                this.checkedChangeListener.onCheckedChanged((View)this, checked);
            }
        }
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            ShapeButton.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public boolean performClick() {
        this.toggle();
        boolean handled = super.performClick();
        if (!handled) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @Override
    @MainThread
    public void setClipPathBorderRadius(@Dimension float borderRadius) {
        this.clippableViewDelegate.setClipPathBorderRadius((View)this, borderRadius);
    }

    public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener2) {
        this.checkedChangeListener = listener2;
    }

    private void updateText() {
        if (this.text != null && this.checkedTextAppearance != null && this.uncheckedTextAppearance != null) {
            LayoutUtils.applyTextAppearance((TextView)this, this.isChecked() ? this.checkedTextAppearance : this.uncheckedTextAppearance);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(View var1, boolean var2);
    }
}

