/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import com.urbanairship.android.layout.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WeightlessLinearLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation;
    private int gravity = 0x800033;
    private int totalLength;
    private static final String ACCESSIBILITY_CLASS_NAME = "com.urbanairship.android.layout.widget.WeightlessLinearLayout";

    public WeightlessLinearLayout(@NonNull Context context) {
        this(context, null);
    }

    public WeightlessLinearLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WeightlessLinearLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WeightlessLinearLayout, defStyleAttr, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this, (Context)context, (int[])R.styleable.WeightlessLinearLayout, (AttributeSet)attrs, (TypedArray)typedArray, (int)defStyleAttr, (int)0);
        int index = typedArray.getInt(R.styleable.WeightlessLinearLayout_android_orientation, -1);
        if (index >= 0) {
            this.setOrientation(index);
        }
        if ((index = typedArray.getInt(R.styleable.WeightlessLinearLayout_android_gravity, -1)) >= 0) {
            this.setGravity(index);
        }
        typedArray.recycle();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.requestLayout();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setGravity(int gravity) {
        if (this.gravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.gravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.gravity & 0x800007) != gravity) {
            this.gravity = this.gravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.gravity & 0x70) != gravity) {
            this.gravity = this.gravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        if (this.orientation == 0) {
            return new LayoutParams(-2, -1);
        }
        if (this.orientation == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.orientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.orientation == 1) {
            this.layoutVertical(l, t, r, b);
        } else {
            this.layoutHorizontal(l, t, r, b);
        }
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        this.totalLength = 0;
        int maxWidth = 0;
        int childState = 0;
        int alternativeMaxWidth = 0;
        int percentMaxWidth = 0;
        boolean allFillParent = true;
        int count = this.getChildCount();
        ArrayList<View> childrenWithMaxPercent = new ArrayList<View>();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean matchWidth = false;
        boolean skippedMeasure = false;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.maxHeightPercent > 0.0f) {
                childrenWithMaxPercent.add(child);
            }
            if (heightMode == 0x40000000 && lp.height == 0 && lp.maxHeightPercent > 0.0f) {
                int totalLength = this.totalLength;
                this.totalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
                skippedMeasure = true;
            } else {
                int oldHeight = Integer.MIN_VALUE;
                if (lp.height == 0 && lp.maxHeightPercent > 0.0f) {
                    oldHeight = 0;
                    lp.height = -2;
                }
                int childHorizontalMargins = lp.getMarginStart() + lp.getMarginEnd();
                int oldWidth = Integer.MIN_VALUE;
                if (lp.width == 0 && lp.maxWidthPercent > 0.0f) {
                    oldWidth = 0;
                    lp.width = (int)((float)widthSize * lp.maxWidthPercent) - childHorizontalMargins;
                }
                this.measureChildWithMargins(child, widthMeasureSpec, childHorizontalMargins, heightMeasureSpec, childrenWithMaxPercent.size() > 0 ? this.totalLength : 0);
                if (oldHeight != Integer.MIN_VALUE) {
                    lp.height = oldHeight;
                }
                if (oldWidth != Integer.MIN_VALUE) {
                    lp.width = oldWidth;
                }
                int childHeight = child.getMeasuredHeight();
                int totalLength = this.totalLength;
                this.totalLength = Math.max(totalLength, totalLength + childHeight + lp.topMargin + lp.bottomMargin);
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.getMarginStart() + lp.getMarginEnd();
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            childState = View.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            boolean bl = allFillParent = allFillParent && lp.width == -1;
            if (lp.maxHeightPercent > 0.0f) {
                percentMaxWidth = Math.max(percentMaxWidth, matchWidthLocally ? margin : measuredWidth);
                continue;
            }
            alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
        }
        this.totalLength += this.getPaddingTop() + this.getPaddingBottom();
        int height = this.totalLength;
        height = Math.max(height, this.getSuggestedMinimumHeight());
        int heightSizeAndState = View.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)0);
        height = heightSizeAndState & 0xFFFFFF;
        int delta = height - this.totalLength;
        if (skippedMeasure || delta != 0 && childrenWithMaxPercent.size() > 0) {
            int i;
            Collections.sort(childrenWithMaxPercent, (v1, v2) -> {
                float p1 = ((LayoutParams)v1.getLayoutParams()).maxHeightPercent;
                float p2 = ((LayoutParams)v2.getLayoutParams()).maxHeightPercent;
                return Float.compare(p1, p2);
            });
            int maxPercentCount = childrenWithMaxPercent.size();
            int lastChildIndex = maxPercentCount - 1;
            for (i = 0; i < maxPercentCount; ++i) {
                int widthSpec;
                View child = (View)childrenWithMaxPercent.get(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (heightMode == 0) continue;
                float actualPercent = (float)delta >= (float)height * lp.maxHeightPercent * (float)(maxPercentCount - i) ? lp.maxHeightPercent : (float)delta / (float)(childrenWithMaxPercent.size() - i) / (float)height;
                int childHeight = (int)(actualPercent * (float)height) + lp.topMargin + lp.bottomMargin;
                if (i == lastChildIndex) {
                    childHeight = Math.min(childHeight, delta);
                }
                delta -= childHeight;
                if (lp.width == 0 && lp.maxWidthPercent > 0.0f) {
                    int childWidth;
                    if (widthSize == 0 && widthMode == 0) {
                        childWidth = -2;
                        widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0);
                    } else {
                        childWidth = (int)((float)widthSize * lp.maxWidthPercent) - (lp.getMarginStart() + lp.getMarginEnd());
                        widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
                    }
                } else {
                    widthSpec = WeightlessLinearLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingStart() + this.getPaddingEnd() + lp.getMarginStart() + lp.getMarginEnd()), (int)lp.width);
                }
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                child.measure(widthSpec, heightSpec);
                childState = View.combineMeasuredStates((int)childState, (int)(child.getMeasuredState() & 0xFFFFFF00));
            }
            for (i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                int margin = lp.getMarginStart() + lp.getMarginEnd();
                int measuredWidth = child.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp.width == -1;
                int totalLength = this.totalLength;
                this.totalLength = Math.max(totalLength, totalLength + child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            this.totalLength += this.getPaddingTop() + this.getPaddingBottom();
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, percentMaxWidth);
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += this.getPaddingStart() + this.getPaddingEnd();
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(View.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), heightSizeAndState);
        if (matchWidth) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        this.totalLength = 0;
        int maxHeight = 0;
        int childState = 0;
        int alternativeMaxHeight = 0;
        int percentMaxHeight = 0;
        boolean allFillParent = true;
        int count = this.getChildCount();
        ArrayList<View> childrenWithMaxPercent = new ArrayList<View>();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean matchHeight = false;
        boolean skippedMeasure = false;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.maxWidthPercent > 0.0f) {
                childrenWithMaxPercent.add(child);
            }
            if (widthMode == 0x40000000 && lp.width == 0 && lp.maxWidthPercent > 0.0f) {
                int totalLength = this.totalLength;
                this.totalLength = Math.max(totalLength, totalLength + lp.getMarginStart() + lp.getMarginEnd());
                skippedMeasure = true;
            } else {
                int oldWidth = Integer.MIN_VALUE;
                if (lp.width == 0 && lp.maxWidthPercent > 0.0f) {
                    oldWidth = 0;
                    lp.width = -2;
                }
                int childVerticalMargins = lp.topMargin + lp.bottomMargin;
                int oldHeight = Integer.MIN_VALUE;
                if (lp.height == 0 && lp.maxHeightPercent > 0.0f) {
                    oldHeight = 0;
                    lp.height = (int)((float)heightSize * lp.maxHeightPercent) - childVerticalMargins;
                }
                this.measureChildWithMargins(child, widthMeasureSpec, childrenWithMaxPercent.size() > 0 ? this.totalLength : 0, heightMeasureSpec, childVerticalMargins);
                if (oldWidth != Integer.MIN_VALUE) {
                    lp.width = oldWidth;
                }
                if (oldHeight != Integer.MIN_VALUE) {
                    lp.height = oldHeight;
                }
                int childWidth = child.getMeasuredWidth();
                int totalLength = this.totalLength;
                this.totalLength = Math.max(totalLength, totalLength + childWidth + lp.getMarginStart() + lp.getMarginEnd());
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int measuredHeight = child.getMeasuredHeight() + margin;
            maxHeight = Math.max(maxHeight, measuredHeight);
            childState = View.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            boolean bl = allFillParent = allFillParent && lp.height == -1;
            if (lp.maxWidthPercent > 0.0f) {
                percentMaxHeight = Math.max(percentMaxHeight, matchHeightLocally ? margin : measuredHeight);
                continue;
            }
            alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : measuredHeight);
        }
        this.totalLength += this.getPaddingStart() + this.getPaddingEnd();
        int width = this.totalLength;
        width = Math.max(width, this.getSuggestedMinimumWidth());
        int widthSizeAndState = View.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)0);
        width = widthSizeAndState & 0xFFFFFF;
        int delta = width - this.totalLength;
        if (skippedMeasure || delta != 0 && childrenWithMaxPercent.size() > 0) {
            int i;
            Collections.sort(childrenWithMaxPercent, (v1, v2) -> {
                float p1 = ((LayoutParams)v1.getLayoutParams()).maxWidthPercent;
                float p2 = ((LayoutParams)v2.getLayoutParams()).maxWidthPercent;
                return Float.compare(p1, p2);
            });
            int maxPercentCount = childrenWithMaxPercent.size();
            int lastChildIndex = maxPercentCount - 1;
            for (i = 0; i < maxPercentCount; ++i) {
                int heightSpec;
                View child = (View)childrenWithMaxPercent.get(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (widthMode == 0) continue;
                float actualPercent = (float)delta >= (float)width * lp.maxWidthPercent * (float)(maxPercentCount - i) ? lp.maxWidthPercent : (float)delta / (float)(childrenWithMaxPercent.size() - i) / (float)width;
                int childWidth = (int)(actualPercent * (float)width) + lp.getMarginStart() + lp.getMarginEnd();
                if (i == lastChildIndex) {
                    childWidth = Math.min(childWidth, delta);
                }
                delta -= childWidth;
                if (lp.height == 0 && lp.maxHeightPercent > 0.0f) {
                    int childHeight;
                    if (heightSize == 0 && heightMode == 0) {
                        childHeight = -2;
                        heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0);
                    } else {
                        childHeight = (int)((float)heightSize * lp.maxHeightPercent) - (lp.topMargin + lp.bottomMargin);
                        heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    }
                } else {
                    heightSpec = WeightlessLinearLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
                }
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
                child.measure(widthSpec, heightSpec);
                childState = View.combineMeasuredStates((int)childState, (int)(child.getMeasuredState() & 0xFF000000));
            }
            for (i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                int margin = lp.topMargin + lp.bottomMargin;
                int measuredHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, measuredHeight);
                boolean matchHeightLocally = widthMode != 0x40000000 && lp.height == -1;
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : measuredHeight);
                allFillParent = allFillParent && lp.height == -1;
                int totalLength = this.totalLength;
                this.totalLength = Math.max(totalLength, totalLength + child.getMeasuredWidth() + lp.getMarginStart() + lp.getMarginEnd());
            }
            this.totalLength += this.getPaddingStart() + this.getPaddingEnd();
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, percentMaxHeight);
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSizeAndState, View.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)childState));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    private void layoutVertical(int left, int top, int right, int bottom) {
        int paddingLeft = this.getPaddingLeft();
        int width = right - left;
        int childRight = width - this.getPaddingRight();
        int childSpace = width - paddingLeft - this.getPaddingRight();
        int count = this.getChildCount();
        int majorGravity = this.gravity & 0x70;
        int minorGravity = this.gravity & 0x800007;
        switch (majorGravity) {
            case 80: {
                int childTop = this.getPaddingTop() + bottom - top - this.totalLength;
                break;
            }
            case 16: {
                int childTop = this.getPaddingTop() + (bottom - top - this.totalLength) / 2;
                break;
            }
            default: {
                int childTop = this.getPaddingTop();
            }
        }
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            int layoutDirection = ViewCompat.getLayoutDirection((View)this);
            int absoluteGravity = GravityCompat.getAbsoluteGravity((int)gravity, (int)layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            this.setChildFrame(child, childLeft, childTop += lp.topMargin, childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
    }

    private void layoutHorizontal(int left, int top, int right, int bottom) {
        boolean isLayoutRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        int paddingTop = this.getPaddingTop();
        int height = bottom - top;
        int childBottom = height - this.getPaddingBottom();
        int childSpace = height - paddingTop - this.getPaddingBottom();
        int count = this.getChildCount();
        int majorGravity = this.gravity & 0x800007;
        int minorGravity = this.gravity & 0x70;
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        switch (GravityCompat.getAbsoluteGravity((int)majorGravity, (int)layoutDirection)) {
            case 5: {
                int childLeft = this.getPaddingLeft() + right - left - this.totalLength;
                break;
            }
            case 1: {
                int childLeft = this.getPaddingLeft() + (right - left - this.totalLength) / 2;
                break;
            }
            default: {
                int childLeft = this.getPaddingLeft();
            }
        }
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childIndex = start + dir * i;
            View child = this.getChildAt(childIndex);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            this.setChildFrame(child, childLeft += lp.leftMargin, childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    private void setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public float maxWidthPercent = 0.0f;
        public float maxHeightPercent = 0.0f;
        public int gravity = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.WeightlessLinearLayout_Layout);
            this.maxWidthPercent = a.getFloat(R.styleable.WeightlessLinearLayout_Layout_maxPercentWidth, 0.0f);
            this.maxHeightPercent = a.getFloat(R.styleable.WeightlessLinearLayout_Layout_maxPercentHeight, 0.0f);
            this.gravity = a.getInt(R.styleable.WeightlessLinearLayout_Layout_android_layout_gravity, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float maxWidthPercent, float maxHeightPercent) {
            super(width, height);
            this.maxWidthPercent = maxWidthPercent;
            this.maxHeightPercent = maxHeightPercent;
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @NonNull
        public String toString() {
            return String.format("LayoutParams{ width = %d, height = %d, maxWidth = %.2f, maxHeight = %.2f", this.width, this.height, Float.valueOf(this.maxWidthPercent), Float.valueOf(this.maxHeightPercent));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

