/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.environment;

import android.app.Activity;
import android.webkit.WebChromeClient;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.reporting.DisplayTimer;
import com.urbanairship.android.layout.util.Factory;
import com.urbanairship.android.layout.util.ImageCache;
import com.urbanairship.webkit.AirshipWebChromeClient;
import com.urbanairship.webkit.AirshipWebViewClient;

public class ViewEnvironment
implements Environment {
    @NonNull
    private final ComponentActivity activity;
    @NonNull
    private final Factory<WebChromeClient> webChromeClientFactory;
    @NonNull
    private final Factory<AirshipWebViewClient> webViewClientFactory;
    @NonNull
    private final ImageCache imageCache;
    @NonNull
    private final DisplayTimer displayTimer;
    private final boolean isIgnoringSafeAreas;

    public ViewEnvironment(@NonNull ComponentActivity activity, @Nullable Factory<AirshipWebViewClient> webViewClientFactory, @Nullable ImageCache imageCache, @NonNull DisplayTimer displayTimer, boolean isIgnoringSafeAreas) {
        this.activity = activity;
        this.webChromeClientFactory = () -> new AirshipWebChromeClient((Activity)activity);
        this.webViewClientFactory = webViewClientFactory != null ? webViewClientFactory : AirshipWebViewClient::new;
        this.imageCache = imageCache != null ? imageCache : url -> null;
        this.displayTimer = displayTimer;
        this.isIgnoringSafeAreas = isIgnoringSafeAreas;
    }

    @Override
    @NonNull
    public Lifecycle lifecycle() {
        return this.activity.getLifecycle();
    }

    @Override
    @NonNull
    public Factory<WebChromeClient> webChromeClientFactory() {
        return this.webChromeClientFactory;
    }

    @Override
    @NonNull
    public Factory<AirshipWebViewClient> webViewClientFactory() {
        return this.webViewClientFactory;
    }

    @Override
    @NonNull
    public ImageCache imageCache() {
        return this.imageCache;
    }

    @Override
    @NonNull
    public DisplayTimer displayTimer() {
        return this.displayTimer;
    }

    @Override
    public boolean isIgnoringSafeAreas() {
        return this.isIgnoringSafeAreas;
    }
}

