/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventType;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.android.layout.reporting.FormInfo;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.reporting.PagerData;
import com.urbanairship.json.JsonValue;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ReportingEvent
extends Event {
    @NonNull
    private final ReportType reportType;
    @NonNull
    private final LayoutData state;

    protected ReportingEvent(@NonNull ReportType reportType, @Nullable LayoutData state) {
        super(EventType.REPORTING_EVENT);
        this.reportType = reportType;
        this.state = state != null ? state : new LayoutData(null, null);
    }

    @NonNull
    public ReportType getReportType() {
        return this.reportType;
    }

    @NonNull
    public LayoutData getState() {
        return this.state;
    }

    public abstract ReportingEvent overrideState(@NonNull FormInfo var1);

    public abstract ReportingEvent overrideState(@NonNull PagerData var1);

    protected LayoutData copyState(@NonNull FormInfo formInfo) {
        return this.state.withFormInfo(formInfo);
    }

    protected LayoutData copyState(@NonNull PagerData data) {
        return this.state.withPagerData(data);
    }

    private static abstract class PagerReportingEvent
    extends ReportingEvent {
        @NonNull
        private final PagerData pagerData;

        public PagerReportingEvent(@NonNull ReportType type, @NonNull PagerData pagerData, @Nullable LayoutData state) {
            super(type, state);
            this.pagerData = pagerData;
        }

        @NonNull
        public PagerData getPagerData() {
            return this.pagerData;
        }
    }

    private static abstract class DismissReportingEvent
    extends ReportingEvent {
        private final long displayTime;

        public DismissReportingEvent(@NonNull ReportType type, long displayTime, @Nullable LayoutData state) {
            super(type, state);
            this.displayTime = displayTime;
        }

        public long getDisplayTime() {
            return this.displayTime;
        }
    }

    public static class FormDisplay
    extends ReportingEvent {
        @NonNull
        private final FormInfo formInfo;

        public FormDisplay(@NonNull FormInfo formInfo) {
            this(formInfo, new LayoutData(formInfo, null));
        }

        private FormDisplay(@NonNull FormInfo formInfo, @Nullable LayoutData state) {
            super(ReportType.FORM_DISPLAY, state);
            this.formInfo = formInfo;
        }

        @NonNull
        public FormInfo getFormInfo() {
            return this.formInfo;
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new FormDisplay(this.getFormInfo(), this.copyState(formInfo));
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData pagerData) {
            return new FormDisplay(this.getFormInfo(), this.copyState(pagerData));
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.FormDisplay{formInfo='" + this.formInfo + '\'' + ", state=" + this.getState() + '}';
        }
    }

    public static class FormResult
    extends ReportingEvent {
        @NonNull
        private final FormData.BaseForm formData;
        @NonNull
        private final FormInfo formInfo;
        @NonNull
        private final Map<AttributeName, JsonValue> attributes;

        public FormResult(@NonNull FormData.BaseForm formData, @NonNull FormInfo formInfo, @NonNull Map<AttributeName, JsonValue> attributes) {
            this(formData, formInfo, new LayoutData(formInfo, null), attributes);
        }

        private FormResult(@NonNull FormData.BaseForm formData, @NonNull FormInfo formInfo, @Nullable LayoutData state, @NonNull Map<AttributeName, JsonValue> attributes) {
            super(ReportType.FORM_RESULT, state);
            this.formData = formData;
            this.formInfo = formInfo;
            this.attributes = attributes;
        }

        @NonNull
        public FormData.BaseForm getFormData() {
            return this.formData;
        }

        @NonNull
        public FormInfo getFormInfo() {
            return this.formInfo;
        }

        public String toString() {
            return "FormResult{formData=" + this.formData + ", formInfo=" + this.formInfo + ", attributes=" + this.attributes + '}';
        }

        @NonNull
        public Map<AttributeName, JsonValue> getAttributes() {
            return this.attributes;
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new FormResult(this.getFormData(), this.getFormInfo(), this.copyState(formInfo), this.attributes);
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData pagerData) {
            return new FormResult(this.getFormData(), this.getFormInfo(), this.copyState(pagerData), this.attributes);
        }
    }

    public static class DismissFromButton
    extends DismissReportingEvent {
        @NonNull
        private final String buttonId;
        @Nullable
        private final String buttonDescription;
        private final boolean cancel;

        public DismissFromButton(@NonNull String buttonId, @Nullable String buttonDescription, boolean cancel, long displayTime) {
            this(buttonId, buttonDescription, cancel, displayTime, null);
        }

        public DismissFromButton(@NonNull String buttonId, @Nullable String buttonDescription, boolean cancel, long displayTime, @Nullable LayoutData state) {
            super(ReportType.BUTTON_DISMISS, displayTime, state);
            this.buttonId = buttonId;
            this.buttonDescription = buttonDescription;
            this.cancel = cancel;
        }

        @NonNull
        public String getButtonId() {
            return this.buttonId;
        }

        @Nullable
        public String getButtonDescription() {
            return this.buttonDescription;
        }

        public boolean isCancel() {
            return this.cancel;
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new DismissFromButton(this.buttonId, this.buttonDescription, this.cancel, this.getDisplayTime(), this.copyState(formInfo));
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData pagerData) {
            return new DismissFromButton(this.buttonId, this.buttonDescription, this.cancel, this.getDisplayTime(), this.copyState(pagerData));
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.DismissFromButton{buttonId='" + this.buttonId + '\'' + ", buttonDescription='" + this.buttonDescription + '\'' + ", cancel=" + this.cancel + ", state=" + this.getState() + ", displayTime=" + this.getDisplayTime() + '}';
        }
    }

    public static class DismissFromOutside
    extends DismissReportingEvent {
        public DismissFromOutside(long displayTime) {
            this(displayTime, null);
        }

        public DismissFromOutside(long displayTime, @Nullable LayoutData state) {
            super(ReportType.OUTSIDE_DISMISS, displayTime, state);
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.DismissFromOutside{displayTime=" + this.getDisplayTime() + '}';
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new DismissFromOutside(this.getDisplayTime(), this.copyState(formInfo));
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData pagerData) {
            return new DismissFromOutside(this.getDisplayTime(), this.copyState(pagerData));
        }
    }

    public static class ButtonTap
    extends ReportingEvent {
        @NonNull
        private final String buttonId;

        public ButtonTap(@NonNull String buttonId) {
            this(buttonId, null);
        }

        private ButtonTap(@NonNull String buttonId, @Nullable LayoutData state) {
            super(ReportType.BUTTON_TAP, state);
            this.buttonId = buttonId;
        }

        @NonNull
        public String getButtonId() {
            return this.buttonId;
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new ButtonTap(this.buttonId, this.copyState(formInfo));
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData pagerData) {
            return new ButtonTap(this.buttonId, this.copyState(pagerData));
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.ButtonTap{buttonId='" + this.buttonId + '\'' + ", state=" + this.getState() + '}';
        }
    }

    public static class PageSwipe
    extends PagerReportingEvent {
        private final int fromPageIndex;
        private final int toPageIndex;
        private final String fromPageId;
        private final String toPageId;

        public PageSwipe(@NonNull PagerData pagerData, int fromPageIndex, @NonNull String fromPageId, int toPageIndex, @NonNull String toPageId) {
            this(pagerData, fromPageIndex, fromPageId, toPageIndex, toPageId, new LayoutData(null, pagerData));
        }

        private PageSwipe(@NonNull PagerData pagerData, int fromPageIndex, @NonNull String fromPageId, int toPageIndex, @NonNull String toPageId, @Nullable LayoutData state) {
            super(ReportType.PAGE_SWIPE, pagerData, state);
            this.fromPageIndex = fromPageIndex;
            this.fromPageId = fromPageId;
            this.toPageIndex = toPageIndex;
            this.toPageId = toPageId;
        }

        public int getFromPageIndex() {
            return this.fromPageIndex;
        }

        @NonNull
        public String getFromPageId() {
            return this.fromPageId;
        }

        public int getToPageIndex() {
            return this.toPageIndex;
        }

        @NonNull
        public String getToPageId() {
            return this.toPageId;
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new PageSwipe(this.getPagerData(), this.fromPageIndex, this.fromPageId, this.toPageIndex, this.toPageId, this.copyState(formInfo));
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData data) {
            return new PageSwipe(this.getPagerData(), this.fromPageIndex, this.fromPageId, this.toPageIndex, this.toPageId, this.copyState(data));
        }

        public String toString() {
            return "PageSwipe{fromPageIndex=" + this.fromPageIndex + ", toPageIndex=" + this.toPageIndex + ", fromPageId='" + this.fromPageId + '\'' + ", toPageId='" + this.toPageId + '\'' + '}';
        }
    }

    public static class PageView
    extends PagerReportingEvent {
        private final long displayedAt;

        public PageView(@NonNull PagerData pagerData, long displayedAt) {
            super(ReportType.PAGE_VIEW, pagerData, new LayoutData(null, pagerData));
            this.displayedAt = displayedAt;
        }

        private PageView(@NonNull PagerData pagerData, @Nullable LayoutData state, long displayedAt) {
            super(ReportType.PAGE_VIEW, pagerData, state);
            this.displayedAt = displayedAt;
        }

        @Override
        public ReportingEvent overrideState(@NonNull FormInfo formInfo) {
            return new PageView(this.getPagerData(), this.copyState(formInfo), this.displayedAt);
        }

        @Override
        public ReportingEvent overrideState(@NonNull PagerData pagerData) {
            return new PageView(this.getPagerData(), this.copyState(pagerData), this.displayedAt);
        }

        public long getDisplayedAt() {
            return this.displayedAt;
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.PageView{pagerData=" + this.getPagerData() + ", state=" + this.getState() + ", displayedAt=" + this.getDisplayedAt() + '}';
        }
    }

    public static enum ReportType {
        PAGE_VIEW,
        PAGE_SWIPE,
        BUTTON_TAP,
        OUTSIDE_DISMISS,
        BUTTON_DISMISS,
        FORM_RESULT,
        FORM_DISPLAY;

    }
}

