/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventType;
import com.urbanairship.android.layout.reporting.FormInfo;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.reporting.PagerData;

public abstract class WebViewEvent
extends Event {
    @NonNull
    private final LayoutData state;

    public WebViewEvent(@NonNull EventType type, @Nullable LayoutData state) {
        super(type);
        this.state = state != null ? state : new LayoutData(null, null);
    }

    @NonNull
    public LayoutData getState() {
        return this.state;
    }

    public abstract WebViewEvent overrideState(@NonNull FormInfo var1);

    public abstract WebViewEvent overrideState(@NonNull PagerData var1);

    protected LayoutData copyState(@NonNull FormInfo formInfo) {
        return this.state.withFormInfo(formInfo);
    }

    protected LayoutData copyState(@NonNull PagerData data) {
        return this.state.withPagerData(data);
    }

    public static final class Close
    extends WebViewEvent {
        public Close() {
            this((LayoutData)null);
        }

        private Close(@Nullable LayoutData state) {
            super(EventType.WEBVIEW_CLOSE, state);
        }

        @Override
        public WebViewEvent overrideState(@NonNull FormInfo formInfo) {
            return new Close(this.copyState(formInfo));
        }

        @Override
        public WebViewEvent overrideState(@NonNull PagerData pagerData) {
            return new Close(this.copyState(pagerData));
        }

        @NonNull
        public String toString() {
            return "WebViewEvent.Close{state=" + this.getState() + '}';
        }
    }
}

