/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.event.ButtonEvent;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.event.WebViewEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.property.FormBehaviorType;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.android.layout.reporting.FormInfo;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseFormController
extends LayoutModel
implements Identifiable {
    @NonNull
    private final String identifier;
    @Nullable
    private final String responseType;
    @NonNull
    private final BaseModel view;
    @Nullable
    private final FormBehaviorType submitBehavior;
    @NonNull
    private final Map<String, FormData<?>> formData = new HashMap();
    @NonNull
    private final Map<AttributeName, JsonValue> attributes = new HashMap<AttributeName, JsonValue>();
    @NonNull
    private final Map<String, Boolean> inputValidity = new HashMap<String, Boolean>();
    private boolean isDisplayReported = false;
    private boolean isSubmitted = false;

    public BaseFormController(@NonNull ViewType viewType, @NonNull String identifier, @Nullable String responseType, @NonNull BaseModel view, @Nullable FormBehaviorType submitBehavior) {
        super(viewType, null, null);
        this.identifier = identifier;
        this.responseType = responseType;
        this.view = view;
        this.submitBehavior = submitBehavior;
        view.addListener(this);
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getResponseType() {
        return this.responseType;
    }

    @NonNull
    public BaseModel getView() {
        return this.view;
    }

    public boolean hasSubmitBehavior() {
        return this.submitBehavior != null;
    }

    @Override
    public List<BaseModel> getChildren() {
        return Collections.singletonList(this.view);
    }

    protected static String identifierFromJson(@NonNull JsonMap json) throws JsonException {
        return Identifiable.identifierFromJson(json);
    }

    protected static BaseModel viewFromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap viewJson = json.opt("view").optMap();
        return Thomas.model(viewJson);
    }

    @Nullable
    protected static FormBehaviorType submitBehaviorFromJson(@NonNull JsonMap json) throws JsonException {
        String submitString = json.opt("submit").getString();
        return submitString != null ? FormBehaviorType.from(submitString) : null;
    }

    @Override
    public boolean onEvent(@NonNull Event event) {
        Logger.verbose((String)"onEvent: %s", (Object[])new Object[]{event});
        switch (event.getType()) {
            case FORM_INIT: {
                this.onNestedFormInit((FormEvent.Init)event);
                return this.hasSubmitBehavior() || super.onEvent(event);
            }
            case FORM_INPUT_INIT: {
                this.onInputInit((FormEvent.InputInit)event);
                return true;
            }
            case FORM_DATA_CHANGE: {
                this.onDataChange((FormEvent.DataChange)event);
                return true;
            }
            case VIEW_ATTACHED: {
                this.onViewAttached((Event.ViewAttachedToWindow)event);
                if (this.hasSubmitBehavior()) {
                    return true;
                }
                return super.onEvent(event);
            }
            case BUTTON_BEHAVIOR_FORM_SUBMIT: {
                if (this.hasSubmitBehavior()) {
                    this.onSubmit();
                    return true;
                }
                return super.onEvent(((ButtonEvent)event).overrideState(this.getFormInfo()));
            }
            case BUTTON_BEHAVIOR_CANCEL: 
            case BUTTON_BEHAVIOR_DISMISS: {
                return super.onEvent(((ButtonEvent)event).overrideState(this.getFormInfo()));
            }
            case WEBVIEW_CLOSE: {
                return super.onEvent(((WebViewEvent.Close)event).overrideState(this.getFormInfo()));
            }
            case REPORTING_EVENT: {
                return super.onEvent(((ReportingEvent)event).overrideState(this.getFormInfo()));
            }
        }
        return super.onEvent(event);
    }

    private void onSubmit() {
        this.isSubmitted = true;
        this.bubbleEvent(this.getFormResultEvent());
    }

    protected abstract FormEvent.Init getInitEvent();

    protected abstract FormEvent.DataChange getFormDataChangeEvent();

    protected abstract ReportingEvent.FormResult getFormResultEvent();

    private void onNestedFormInit(FormEvent.Init init) {
        this.updateFormValidity(init.getIdentifier(), init.isValid());
    }

    private void onInputInit(FormEvent.InputInit init) {
        this.updateFormValidity(init.getIdentifier(), init.isValid());
        if (this.inputValidity.size() == 1 && !this.hasSubmitBehavior()) {
            this.bubbleEvent(this.getInitEvent());
        }
    }

    private void onViewAttached(Event.ViewAttachedToWindow attach) {
        if (attach.getViewType().isFormInput() && !this.isDisplayReported) {
            this.isDisplayReported = true;
            this.bubbleEvent(new ReportingEvent.FormDisplay(this.getFormInfo()));
        }
    }

    private void onDataChange(FormEvent.DataChange data) {
        String identifier = ((FormData)data.getValue()).getIdentifier();
        boolean isValid = data.isValid();
        if (isValid) {
            this.formData.put(identifier, (FormData)data.getValue());
            this.attributes.putAll(data.getAttributes());
        } else {
            this.formData.remove(identifier);
            for (AttributeName key : data.getAttributes().keySet()) {
                this.attributes.remove(key);
            }
        }
        this.updateFormValidity(identifier, isValid);
        if (!this.hasSubmitBehavior()) {
            this.bubbleEvent(this.getFormDataChangeEvent());
        }
    }

    private void updateFormValidity(@NonNull String inputId, boolean isValid) {
        this.inputValidity.put(inputId, isValid);
        this.trickleEvent(new FormEvent.ValidationUpdate(this.isFormValid()));
    }

    protected boolean isFormValid() {
        for (Map.Entry<String, Boolean> validity : this.inputValidity.entrySet()) {
            if (validity.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NonNull
    protected Collection<FormData<?>> getFormData() {
        return this.formData.values();
    }

    @NonNull
    protected Map<AttributeName, JsonValue> getAttributes() {
        return this.attributes;
    }

    @NonNull
    protected FormInfo getFormInfo() {
        return new FormInfo(this.identifier, this.getFormType(), this.responseType, this.isSubmitted);
    }

    @NonNull
    protected abstract String getFormType();
}

