/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventListener;
import com.urbanairship.android.layout.event.EventSource;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseModel
implements EventSource,
EventListener {
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    @NonNull
    private final ViewType viewType;
    @Nullable
    private final Color backgroundColor;
    @Nullable
    private final Border border;
    private final int viewId;

    public BaseModel(@NonNull ViewType viewType, @Nullable Color backgroundColor, @Nullable Border border) {
        this.viewType = viewType;
        this.backgroundColor = backgroundColor;
        this.border = border;
        this.viewId = View.generateViewId();
    }

    @NonNull
    public ViewType getType() {
        return this.viewType;
    }

    @Nullable
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Nullable
    public Border getBorder() {
        return this.border;
    }

    @Nullable
    public static Color backgroundColorFromJson(@NonNull JsonMap json) throws JsonException {
        return Color.fromJsonField(json, "background_color");
    }

    @Nullable
    public static Border borderFromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap borderJson = json.opt("border").optMap();
        return borderJson.isEmpty() ? null : Border.fromJson(borderJson);
    }

    public int getViewId() {
        return this.viewId;
    }

    @Override
    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setListener(EventListener listener) {
        this.listeners.clear();
        this.listeners.add(listener);
    }

    @Override
    public boolean onEvent(@NonNull Event event) {
        return false;
    }

    protected boolean bubbleEvent(@NonNull Event event) {
        for (EventListener listener : this.listeners) {
            if (!listener.onEvent(event)) continue;
            return true;
        }
        return false;
    }

    protected boolean trickleEvent(@NonNull Event event) {
        return this.onEvent(event);
    }
}

