/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.model.SafeAreaAware;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.android.layout.property.Size;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.ArrayList;
import java.util.List;

public class ContainerLayoutModel
extends LayoutModel {
    @NonNull
    private final List<Item> items;
    @NonNull
    private final List<BaseModel> children = new ArrayList<BaseModel>();

    public ContainerLayoutModel(@NonNull List<Item> items, @Nullable Border border, @Nullable Color backgroundColor) {
        super(ViewType.CONTAINER, backgroundColor, border);
        this.items = items;
        for (Item item : items) {
            item.view.addListener(this);
            this.children.add(item.view);
        }
    }

    @NonNull
    public static ContainerLayoutModel fromJson(@NonNull JsonMap json) throws JsonException {
        JsonList itemsJson = json.opt("items").optList();
        List<Item> items = Item.fromJsonList(itemsJson);
        Color backgroundColor = ContainerLayoutModel.backgroundColorFromJson(json);
        Border border = ContainerLayoutModel.borderFromJson(json);
        return new ContainerLayoutModel(items, border, backgroundColor);
    }

    @NonNull
    public List<Item> getItems() {
        return this.items;
    }

    @Override
    @NonNull
    public List<BaseModel> getChildren() {
        return this.children;
    }

    public static class Item
    implements SafeAreaAware {
        @NonNull
        private final Position position;
        @NonNull
        private final Size size;
        @NonNull
        private final BaseModel view;
        @Nullable
        private final Margin margin;
        private final boolean ignoreSafeArea;

        public Item(@NonNull Position position, @NonNull Size size, @NonNull BaseModel view, @Nullable Margin margin, boolean ignoreSafeArea) {
            this.position = position;
            this.size = size;
            this.view = view;
            this.margin = margin;
            this.ignoreSafeArea = ignoreSafeArea;
        }

        @NonNull
        public static Item fromJson(@NonNull JsonMap json) throws JsonException {
            JsonMap positionJson = json.opt("position").optMap();
            JsonMap sizeJson = json.opt("size").optMap();
            JsonMap viewJson = json.opt("view").optMap();
            JsonMap marginJson = json.opt("margin").optMap();
            Position position = Position.fromJson(positionJson);
            Size size = Size.fromJson(sizeJson);
            BaseModel view = Thomas.model(viewJson);
            Margin margin = marginJson.isEmpty() ? null : Margin.fromJson(marginJson);
            boolean ignoreSafeArea = SafeAreaAware.ignoreSafeAreaFromJson(json);
            return new Item(position, size, view, margin, ignoreSafeArea);
        }

        @NonNull
        public static List<Item> fromJsonList(@NonNull JsonList json) throws JsonException {
            ArrayList<Item> items = new ArrayList<Item>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JsonMap itemJson = json.get(i).optMap();
                Item item = Item.fromJson(itemJson);
                items.add(item);
            }
            return items;
        }

        @NonNull
        public Position getPosition() {
            return this.position;
        }

        @NonNull
        public Size getSize() {
            return this.size;
        }

        @NonNull
        public BaseModel getView() {
            return this.view;
        }

        @Nullable
        public Margin getMargin() {
            return this.margin;
        }

        @Override
        public boolean shouldIgnoreSafeArea() {
            return this.ignoreSafeArea;
        }
    }
}

