/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.ButtonModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.LabelModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.ButtonClickBehaviorType;
import com.urbanairship.android.layout.property.ButtonEnableBehaviorType;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.UAStringUtil;
import java.util.List;
import java.util.Map;

public class LabelButtonModel
extends ButtonModel {
    @NonNull
    private final LabelModel label;

    public LabelButtonModel(@NonNull String id2, @NonNull LabelModel label, @NonNull List<ButtonClickBehaviorType> clickBehaviors, @NonNull Map<String, JsonValue> actions, @NonNull List<ButtonEnableBehaviorType> enableBehaviors, @Nullable Color backgroundColor, @Nullable Border border, @Nullable String contentDescription) {
        super(ViewType.LABEL_BUTTON, id2, clickBehaviors, actions, enableBehaviors, backgroundColor, border, contentDescription);
        this.label = label;
    }

    @NonNull
    public static LabelButtonModel fromJson(@NonNull JsonMap json) throws JsonException {
        String id2 = Identifiable.identifierFromJson(json);
        JsonMap labelJson = json.opt("label").optMap();
        LabelModel label = LabelModel.fromJson(labelJson);
        List<ButtonClickBehaviorType> clickBehaviors = LabelButtonModel.buttonClickBehaviorsFromJson(json);
        Map<String, JsonValue> actions = LabelButtonModel.actionsFromJson(json);
        List<ButtonEnableBehaviorType> enableBehaviors = LabelButtonModel.buttonEnableBehaviorsFromJson(json);
        Color backgroundColor = LabelButtonModel.backgroundColorFromJson(json);
        Border border = LabelButtonModel.borderFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        return new LabelButtonModel(id2, label, clickBehaviors, actions, enableBehaviors, backgroundColor, border, contentDescription);
    }

    @NonNull
    public LabelModel getLabel() {
        return this.label;
    }

    @Override
    @NonNull
    public String reportingDescription() {
        String labelOrIdentifier = !UAStringUtil.isEmpty((String)this.getLabel().getText()) ? this.getLabel().getText() : this.getIdentifier();
        return !UAStringUtil.isEmpty((String)this.getContentDescription()) ? this.getContentDescription() : labelOrIdentifier;
    }
}

