/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.CheckboxController;
import com.urbanairship.android.layout.model.ContainerLayoutModel;
import com.urbanairship.android.layout.model.FormController;
import com.urbanairship.android.layout.model.LinearLayoutModel;
import com.urbanairship.android.layout.model.NpsFormController;
import com.urbanairship.android.layout.model.PagerController;
import com.urbanairship.android.layout.model.RadioInputController;
import com.urbanairship.android.layout.model.ScrollLayoutModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class LayoutModel
extends BaseModel {
    public LayoutModel(@NonNull ViewType viewType, @Nullable Color backgroundColor, @Nullable Border border) {
        super(viewType, backgroundColor, border);
    }

    @NonNull
    public static LayoutModel fromJson(@NonNull JsonMap json) throws JsonException {
        String typeString = json.opt("type").optString();
        switch (ViewType.from(typeString)) {
            case CONTAINER: {
                return ContainerLayoutModel.fromJson(json);
            }
            case LINEAR_LAYOUT: {
                return LinearLayoutModel.fromJson(json);
            }
            case SCROLL_LAYOUT: {
                return ScrollLayoutModel.fromJson(json);
            }
            case PAGER_CONTROLLER: {
                return PagerController.fromJson(json);
            }
            case FORM_CONTROLLER: {
                return FormController.fromJson(json);
            }
            case NPS_FORM_CONTROLLER: {
                return NpsFormController.fromJson(json);
            }
            case CHECKBOX_CONTROLLER: {
                return CheckboxController.fromJson(json);
            }
            case RADIO_INPUT_CONTROLLER: {
                return RadioInputController.fromJson(json);
            }
        }
        throw new JsonException("Error inflating layout! Unrecognized view type: " + typeString);
    }

    public abstract List<BaseModel> getChildren();

    @Override
    public boolean onEvent(@NonNull Event event) {
        return this.bubbleEvent(event);
    }

    @Override
    public boolean trickleEvent(@NonNull Event event) {
        for (BaseModel child : this.getChildren()) {
            if (!child.trickleEvent(event)) continue;
            return true;
        }
        return false;
    }
}

