/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.PagerEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PagerModel
extends LayoutModel {
    @NonNull
    private final List<Item> items;
    @NonNull
    private final List<BaseModel> children = new ArrayList<BaseModel>();
    private final boolean disableSwipe;
    @Nullable
    private Listener listener;
    private int lastIndex = 0;
    private final int recyclerViewId = View.generateViewId();
    private final HashMap<Integer, Integer> pageViewIds = new HashMap();

    public PagerModel(@NonNull List<Item> items, boolean disableSwipe, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.PAGER, backgroundColor, border);
        this.items = items;
        this.disableSwipe = disableSwipe;
        for (Item item : items) {
            item.view.addListener(this);
            this.children.add(item.view);
        }
    }

    @NonNull
    public static PagerModel fromJson(@NonNull JsonMap json) throws JsonException {
        JsonList itemsJson = json.opt("items").optList();
        boolean disableSwipe = json.opt("disable_swipe").getBoolean(false);
        Color backgroundColor = PagerModel.backgroundColorFromJson(json);
        Border border = PagerModel.borderFromJson(json);
        List<Item> items = Item.fromJsonList(itemsJson);
        return new PagerModel(items, disableSwipe, backgroundColor, border);
    }

    @Override
    @NonNull
    public List<BaseModel> getChildren() {
        return this.children;
    }

    public int getRecyclerViewId() {
        return this.recyclerViewId;
    }

    public int getPageViewId(int position) {
        Integer viewId = null;
        if (this.pageViewIds.containsKey(position)) {
            viewId = this.pageViewIds.get(position);
        }
        if (viewId == null) {
            viewId = View.generateViewId();
            this.pageViewIds.put(position, viewId);
        }
        return viewId;
    }

    @NonNull
    public List<Item> getItems() {
        return this.items;
    }

    public boolean isSwipeDisabled() {
        return this.disableSwipe;
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void onScrollTo(int position, boolean isInternalScroll, long time) {
        if (position == this.lastIndex) {
            return;
        }
        Item item = this.items.get(position);
        String pageId = item.identifier;
        Map pageActions = item.actions;
        String previousPageId = this.items.get(this.lastIndex).identifier;
        this.bubbleEvent(new PagerEvent.Scroll(this, position, pageId, pageActions, this.lastIndex, previousPageId, isInternalScroll, time));
        this.lastIndex = position;
    }

    public void onConfigured(int position, long time) {
        Item item = this.items.get(position);
        String pageId = item.identifier;
        Map pageActions = item.actions;
        this.bubbleEvent(new PagerEvent.Init(this, position, pageId, pageActions, time));
    }

    @Override
    public boolean onEvent(@NonNull Event event) {
        Logger.verbose((String)"onEvent: %s", (Object[])new Object[]{event});
        return this.onEvent(event, true);
    }

    private boolean onEvent(@NonNull Event event, boolean bubbleIfUnhandled) {
        switch (event.getType()) {
            case BUTTON_BEHAVIOR_PAGER_NEXT: {
                if (this.listener != null) {
                    this.listener.onScrollToNext();
                }
                return true;
            }
            case BUTTON_BEHAVIOR_PAGER_PREVIOUS: {
                if (this.listener != null) {
                    this.listener.onScrollToPrevious();
                }
                return true;
            }
        }
        return bubbleIfUnhandled && super.onEvent(event);
    }

    @Override
    public boolean trickleEvent(@NonNull Event event) {
        if (this.onEvent(event, false)) {
            return true;
        }
        return super.trickleEvent(event);
    }

    public static class Item {
        @NonNull
        private final BaseModel view;
        @NonNull
        private final String identifier;
        @NonNull
        private final Map<String, JsonValue> actions;

        public Item(@NonNull BaseModel view, @NonNull String identifier, @NonNull Map<String, JsonValue> actions) {
            this.view = view;
            this.identifier = identifier;
            this.actions = actions;
        }

        @NonNull
        public static Item fromJson(@NonNull JsonMap json) throws JsonException {
            JsonMap viewJson = json.opt("view").optMap();
            String identifier = Identifiable.identifierFromJson(json);
            Map actions = json.opt("display_actions").optMap().getMap();
            BaseModel view = Thomas.model(viewJson);
            return new Item(view, identifier, actions);
        }

        @NonNull
        public static List<Item> fromJsonList(@NonNull JsonList json) throws JsonException {
            ArrayList<Item> items = new ArrayList<Item>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JsonMap itemJson = json.get(i).optMap();
                Item item = Item.fromJson(itemJson);
                items.add(item);
            }
            return items;
        }

        @NonNull
        public BaseModel getView() {
            return this.view;
        }

        @NonNull
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static interface Listener {
        public void onScrollToNext();

        public void onScrollToPrevious();
    }
}

