/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.RadioEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.model.RadioInputModel;
import com.urbanairship.android.layout.model.Validatable;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RadioInputController
extends LayoutModel
implements Identifiable,
Accessible,
Validatable {
    @NonNull
    private final String identifier;
    @NonNull
    private final BaseModel view;
    @Nullable
    private final AttributeName attributeName;
    private final boolean isRequired;
    @Nullable
    private final String contentDescription;
    @NonNull
    private final List<RadioInputModel> radioInputs = new ArrayList<RadioInputModel>();
    @Nullable
    private JsonValue selectedValue = null;

    public RadioInputController(@NonNull String identifier, @NonNull BaseModel view, @Nullable AttributeName attributeName, boolean isRequired, @Nullable String contentDescription) {
        super(ViewType.RADIO_INPUT_CONTROLLER, null, null);
        this.identifier = identifier;
        this.view = view;
        this.attributeName = attributeName;
        this.isRequired = isRequired;
        this.contentDescription = contentDescription;
        view.addListener(this);
    }

    @NonNull
    public static RadioInputController fromJson(@NonNull JsonMap json) throws JsonException {
        String identifier = Identifiable.identifierFromJson(json);
        JsonMap viewJson = json.opt("view").optMap();
        AttributeName attributeName = AttributeName.attributeNameFromJson(json);
        boolean isRequired = Validatable.requiredFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        BaseModel view = Thomas.model(viewJson);
        return new RadioInputController(identifier, view, attributeName, isRequired, contentDescription);
    }

    @Override
    public List<BaseModel> getChildren() {
        return Collections.singletonList(this.view);
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @NonNull
    public BaseModel getView() {
        return this.view;
    }

    @Override
    public boolean isValid() {
        return this.selectedValue != null || !this.isRequired;
    }

    @NonNull
    @VisibleForTesting
    public List<RadioInputModel> getRadioInputs() {
        return this.radioInputs;
    }

    @Nullable
    @VisibleForTesting
    public JsonValue getSelectedValue() {
        return this.selectedValue;
    }

    @Override
    public boolean onEvent(@NonNull Event event) {
        switch (event.getType()) {
            case VIEW_INIT: {
                return this.onViewInit((Event.ViewInit)event);
            }
            case RADIO_INPUT_CHANGE: {
                return this.onInputChange((RadioEvent.InputChange)event);
            }
            case VIEW_ATTACHED: {
                return this.onViewAttached((Event.ViewAttachedToWindow)event);
            }
        }
        return super.onEvent(event);
    }

    private boolean onViewInit(Event.ViewInit event) {
        if (event.getViewType() == ViewType.RADIO_INPUT) {
            RadioInputModel model;
            if (this.radioInputs.isEmpty()) {
                this.bubbleEvent(new RadioEvent.ControllerInit(this.identifier, this.isValid()));
            }
            if (!this.radioInputs.contains(model = (RadioInputModel)event.getModel())) {
                this.radioInputs.add(model);
            }
            return true;
        }
        return false;
    }

    private boolean onInputChange(RadioEvent.InputChange event) {
        if (event.isChecked() && !((JsonValue)event.getValue()).equals((Object)this.selectedValue)) {
            this.selectedValue = (JsonValue)event.getValue();
            this.trickleEvent(new RadioEvent.ViewUpdate((JsonValue)event.getValue(), event.isChecked()));
            this.bubbleEvent(new FormEvent.DataChange(new FormData.RadioInputController(this.identifier, (JsonValue)event.getValue()), this.isValid(), this.attributeName, event.getAttributeValue()));
        }
        return true;
    }

    private boolean onViewAttached(Event.ViewAttachedToWindow event) {
        JsonValue value;
        boolean isSelected;
        if (event.getViewType() == ViewType.RADIO_INPUT && event.getModel() instanceof RadioInputModel && this.selectedValue != null && (isSelected = this.selectedValue.equals((Object)(value = ((RadioInputModel)event.getModel()).getReportingValue())))) {
            this.trickleEvent(new RadioEvent.ViewUpdate(value, true));
        }
        return super.onEvent(event);
    }
}

