/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.ScoreEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.Validatable;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ScoreStyle;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;

public class ScoreModel
extends BaseModel
implements Identifiable,
Accessible,
Validatable {
    @NonNull
    private final String identifier;
    @NonNull
    private final ScoreStyle style;
    @Nullable
    private final AttributeName attributeName;
    private final boolean isRequired;
    @Nullable
    private final String contentDescription;
    @Nullable
    private Integer selectedScore = null;

    public ScoreModel(@NonNull String identifier, @NonNull ScoreStyle style, @Nullable AttributeName attributeName, boolean isRequired, @Nullable String contentDescription, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.SCORE, backgroundColor, border);
        this.identifier = identifier;
        this.style = style;
        this.attributeName = attributeName;
        this.isRequired = isRequired;
        this.contentDescription = contentDescription;
    }

    @NonNull
    public static ScoreModel fromJson(@NonNull JsonMap json) throws JsonException {
        String identifier = Identifiable.identifierFromJson(json);
        JsonMap styleJson = json.opt("style").optMap();
        ScoreStyle style = ScoreStyle.fromJson(styleJson);
        AttributeName attributeName = AttributeName.attributeNameFromJson(json);
        boolean required = Validatable.requiredFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        Color backgroundColor = ScoreModel.backgroundColorFromJson(json);
        Border border = ScoreModel.borderFromJson(json);
        return new ScoreModel(identifier, style, attributeName, required, contentDescription, backgroundColor, border);
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @NonNull
    public ScoreStyle getStyle() {
        return this.style;
    }

    @Nullable
    public Integer getSelectedScore() {
        return this.selectedScore;
    }

    @Override
    public boolean isValid() {
        return this.selectedScore != null && this.selectedScore > -1 || !this.isRequired;
    }

    public void onConfigured() {
        this.bubbleEvent(new ScoreEvent.Init(this.identifier, this.isValid()));
    }

    public void onAttachedToWindow() {
        this.bubbleEvent(new Event.ViewAttachedToWindow(this));
    }

    public void onScoreChange(int score) {
        this.selectedScore = score;
        this.bubbleEvent(new FormEvent.DataChange(new FormData.Score(this.identifier, score), this.isValid(), this.attributeName, JsonValue.wrap((int)score)));
    }
}

