/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.TextInputEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.Validatable;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.FormInputType;
import com.urbanairship.android.layout.property.TextInputTextAppearance;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.util.UAStringUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TextInputModel
extends BaseModel
implements Identifiable,
Accessible,
Validatable {
    @NonNull
    private final String identifier;
    @NonNull
    private final FormInputType inputType;
    @NonNull
    private final TextInputTextAppearance textAppearance;
    @Nullable
    private final String hintText;
    @Nullable
    private final String contentDescription;
    private final boolean isRequired;
    @Nullable
    private String value = null;

    public TextInputModel(@NonNull String identifier, @NonNull FormInputType inputType, @NonNull TextInputTextAppearance textAppearance, @Nullable String hintText, @Nullable String contentDescription, boolean isRequired, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.TEXT_INPUT, backgroundColor, border);
        this.identifier = identifier;
        this.inputType = inputType;
        this.textAppearance = textAppearance;
        this.hintText = hintText;
        this.contentDescription = contentDescription;
        this.isRequired = isRequired;
    }

    @NonNull
    public static TextInputModel fromJson(@NonNull JsonMap json) throws JsonException {
        String inputTypeString = json.opt("input_type").optString();
        FormInputType inputType = FormInputType.from(inputTypeString);
        String hintText = json.opt("place_holder").getString();
        Color hintColor = Color.fromJsonField(json, "place_holder_text_color");
        JsonMap textAppearanceJson = json.opt("text_appearance").optMap();
        TextInputTextAppearance textAppearance = TextInputTextAppearance.fromJson(textAppearanceJson);
        String identifier = Identifiable.identifierFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        boolean required = Validatable.requiredFromJson(json);
        Color backgroundColor = TextInputModel.backgroundColorFromJson(json);
        Border border = TextInputModel.borderFromJson(json);
        return new TextInputModel(identifier, inputType, textAppearance, hintText, contentDescription, required, backgroundColor, border);
    }

    @NonNull
    public BaseModel getView() {
        return this;
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isValid() {
        return !this.isRequired || !UAStringUtil.isEmpty((String)this.value);
    }

    @NonNull
    public FormInputType getInputType() {
        return this.inputType;
    }

    @NonNull
    public TextInputTextAppearance getTextAppearance() {
        return this.textAppearance;
    }

    @Nullable
    public String getHintText() {
        return this.hintText;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public void onConfigured() {
        this.bubbleEvent(new TextInputEvent.Init(this.identifier, this.isValid()));
    }

    public void onAttachedToWindow() {
        this.bubbleEvent(new Event.ViewAttachedToWindow(this));
    }

    public void onInputChange(@NonNull String value) {
        this.value = value;
        this.bubbleEvent(new FormEvent.DataChange(new FormData.TextInput(this.identifier, value), this.isValid()));
    }
}

