/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.HexColor;
import com.urbanairship.android.layout.property.Platform;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.ArrayList;
import java.util.List;

public class ColorSelector {
    @Nullable
    private final Platform platform;
    private final boolean darkMode;
    @ColorInt
    private final int color;

    public ColorSelector(@Nullable Platform platform, boolean darkMode, int color) {
        this.platform = platform;
        this.darkMode = darkMode;
        this.color = color;
    }

    @NonNull
    public static ColorSelector fromJson(@NonNull JsonMap json) throws JsonException {
        String platformString = json.opt("platform").optString();
        Platform platform = platformString.isEmpty() ? null : Platform.from(platformString);
        boolean darkMode = json.opt("dark_mode").getBoolean(false);
        JsonMap colorJson = json.opt("color").optMap();
        Integer color = HexColor.fromJson(colorJson);
        if (color == null) {
            throw new JsonException("Failed to parse color selector. 'color' may not be null! json = '" + json + "'");
        }
        return new ColorSelector(platform, darkMode, color);
    }

    @NonNull
    public static List<ColorSelector> fromJsonList(@NonNull JsonList json) throws JsonException {
        ArrayList<ColorSelector> selectors = new ArrayList<ColorSelector>(json.size());
        for (int i = 0; i < json.size(); ++i) {
            JsonMap selectorJson = json.get(i).optMap();
            ColorSelector selector = ColorSelector.fromJson(selectorJson);
            if (selector.platform != Platform.ANDROID) continue;
            selectors.add(selector);
        }
        return selectors;
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }

    @ColorInt
    public int getColor() {
        return this.color;
    }
}

