/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum Direction {
    VERTICAL("vertical"),
    HORIZONTAL("horizontal");

    @NonNull
    private final String value;

    private Direction(String value) {
        this.value = value;
    }

    @NonNull
    public static Direction from(@NonNull String value) throws JsonException {
        for (Direction d : Direction.values()) {
            if (!d.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return d;
        }
        throw new JsonException("Unknown Direction value: " + value);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

