/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.ui;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.WindowCompat;
import androidx.lifecycle.LifecycleOwner;
import com.urbanairship.Logger;
import com.urbanairship.UAirship;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.ThomasListener;
import com.urbanairship.android.layout.display.DisplayArgs;
import com.urbanairship.android.layout.display.DisplayArgsLoader;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.event.ButtonEvent;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventListener;
import com.urbanairship.android.layout.event.EventSource;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.event.WebViewEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ModalPresentation;
import com.urbanairship.android.layout.property.ModalPlacement;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.DisplayTimer;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.ui.ThomasListenerProxy;
import com.urbanairship.android.layout.util.ActionsRunner;
import com.urbanairship.android.layout.view.ModalView;
import com.urbanairship.channel.AttributeEditor;
import com.urbanairship.json.JsonValue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ModalActivity
extends AppCompatActivity
implements EventListener,
EventSource {
    public static final String EXTRA_DISPLAY_ARGS_LOADER = "com.urbanairship.android.layout.ui.EXTRA_DISPLAY_ARGS_LOADER";
    private static final String KEY_DISPLAY_TIME = "display_time";
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    @Nullable
    private DisplayArgsLoader loader;
    @Nullable
    private ThomasListener externalListener;
    @Nullable
    private ActionsRunner actionsRunner;
    private DisplayTimer displayTimer;
    private boolean disableBackButton = false;
    private ModalView modalView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loader = (DisplayArgsLoader)this.getIntent().getParcelableExtra(EXTRA_DISPLAY_ARGS_LOADER);
        if (this.loader == null) {
            Logger.error((String)"Missing layout args loader", (Object[])new Object[0]);
            this.finish();
            return;
        }
        try {
            DisplayArgs args = this.loader.getDisplayArgs();
            if (!(args.getPayload().getPresentation() instanceof ModalPresentation)) {
                Logger.error((String)"Not a modal presentation", (Object[])new Object[0]);
                this.finish();
                return;
            }
            this.externalListener = args.getListener();
            this.actionsRunner = args.getActionsRunner();
            ModalPresentation presentation = (ModalPresentation)args.getPayload().getPresentation();
            long restoredTime = savedInstanceState != null ? savedInstanceState.getLong(KEY_DISPLAY_TIME) : 0L;
            this.displayTimer = new DisplayTimer((LifecycleOwner)this, restoredTime);
            ModalPlacement placement = presentation.getResolvedPlacement((Context)this);
            this.setOrientationLock(placement);
            if (placement.shouldIgnoreSafeArea()) {
                WindowCompat.setDecorFitsSystemWindows((Window)this.getWindow(), (boolean)false);
                this.getWindow().setStatusBarColor(R.color.system_bar_scrim_dark);
                this.getWindow().setNavigationBarColor(R.color.system_bar_scrim_dark);
            }
            ViewEnvironment environment = new ViewEnvironment((ComponentActivity)this, args.getWebViewClientFactory(), args.getImageCache(), this.displayTimer, placement.shouldIgnoreSafeArea());
            BaseModel view = args.getPayload().getView();
            view.setListener(this);
            if (this.externalListener != null) {
                this.setListener(new ThomasListenerProxy(this.externalListener));
            }
            this.modalView = ModalView.create((Context)this, view, presentation, environment);
            this.modalView.setLayoutParams((ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(-1, -1));
            if (presentation.isDismissOnTouchOutside()) {
                this.modalView.setOnClickOutsideListener(v -> {
                    this.onEvent(new ReportingEvent.DismissFromOutside(this.displayTimer.getTime()));
                    this.finish();
                });
            }
            this.disableBackButton = presentation.isDisableBackButton();
            this.setContentView((View)this.modalView);
        }
        catch (DisplayArgsLoader.LoadException e) {
            Logger.error((String)"Failed to load model!", (Object[])new Object[]{e});
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.loader != null && this.isFinishing()) {
            this.loader.dispose();
        }
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(KEY_DISPLAY_TIME, this.displayTimer.getTime());
    }

    public void onBackPressed() {
        if (!this.disableBackButton) {
            super.onBackPressed();
            this.reportDismissFromOutside(null);
        }
    }

    @Override
    public boolean onEvent(@NonNull Event event) {
        Logger.verbose((String)"onEvent: %s", (Object[])new Object[]{event});
        switch (event.getType()) {
            case BUTTON_BEHAVIOR_CANCEL: 
            case BUTTON_BEHAVIOR_DISMISS: {
                this.reportDismissFromButton((ButtonEvent)event);
                this.finish();
                return true;
            }
            case WEBVIEW_CLOSE: {
                this.reportDismissFromOutside(((WebViewEvent)event).getState());
                return true;
            }
            case BUTTON_ACTIONS: 
            case PAGER_PAGE_ACTIONS: {
                return this.runActions(((Event.EventWithActions)((Object)event)).getActions());
            }
            case REPORTING_EVENT: {
                if (((ReportingEvent)event).getReportType() != ReportingEvent.ReportType.FORM_RESULT) break;
                this.applyAttributeUpdates((ReportingEvent.FormResult)event);
            }
        }
        for (EventListener listener : this.listeners) {
            if (!listener.onEvent(event)) continue;
            return true;
        }
        return false;
    }

    private boolean runActions(Map<String, JsonValue> actions) {
        if (this.actionsRunner != null) {
            this.actionsRunner.run(actions);
            return true;
        }
        return false;
    }

    @Override
    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setListener(EventListener listener) {
        this.listeners.clear();
        this.listeners.add(listener);
    }

    private void reportDismissFromButton(ButtonEvent event) {
        this.onEvent(new ReportingEvent.DismissFromButton(event.getIdentifier(), event.getReportingDescription(), event.isCancel(), this.displayTimer.getTime(), event.getState()));
    }

    private void reportDismissFromOutside(@Nullable LayoutData state) {
        this.onEvent(new ReportingEvent.DismissFromOutside(this.displayTimer.getTime(), state));
    }

    private void applyAttributeUpdates(ReportingEvent.FormResult result) {
        AttributeEditor contactEditor = UAirship.shared().getContact().editAttributes();
        AttributeEditor channelEditor = UAirship.shared().getChannel().editAttributes();
        for (Map.Entry<AttributeName, JsonValue> entry : result.getAttributes().entrySet()) {
            AttributeName key = entry.getKey();
            String attribute = key.isContact() ? key.getContact() : key.getChannel();
            JsonValue value = entry.getValue();
            if (attribute == null || value == null || value.isNull()) continue;
            Logger.debug((String)"Setting %s attribute: \"%s\" => %s", (Object[])new Object[]{key.isChannel() ? "channel" : "contact", attribute, value.toString()});
            AttributeEditor editor = key.isContact() ? contactEditor : channelEditor;
            this.setAttribute(editor, attribute, value);
        }
        contactEditor.apply();
        channelEditor.apply();
    }

    private void setAttribute(@NonNull AttributeEditor editor, @NonNull String attribute, @NonNull JsonValue value) {
        if (value.isString()) {
            editor.setAttribute(attribute, value.optString());
        } else if (value.isDouble()) {
            editor.setAttribute(attribute, value.getDouble(-1.0));
        } else if (value.isFloat()) {
            editor.setAttribute(attribute, value.getFloat(-1.0f));
        } else if (value.isInteger()) {
            editor.setAttribute(attribute, value.getInt(-1));
        } else if (value.isLong()) {
            editor.setAttribute(attribute, value.getLong(-1L));
        }
    }

    private void setOrientationLock(@NonNull ModalPlacement placement) {
        try {
            if (placement.getOrientationLock() != null) {
                if (Build.VERSION.SDK_INT != 26) {
                    switch (placement.getOrientationLock()) {
                        case PORTRAIT: {
                            this.setRequestedOrientation(1);
                            break;
                        }
                        case LANDSCAPE: {
                            this.setRequestedOrientation(0);
                        }
                    }
                } else {
                    this.setRequestedOrientation(3);
                }
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Unable to set orientation lock.", (Object[])new Object[0]);
        }
    }
}

