/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.ui;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.ThomasListener;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventListener;
import com.urbanairship.android.layout.event.ReportingEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ThomasListenerProxy
implements EventListener {
    @NonNull
    private final ThomasListener listener;

    public ThomasListenerProxy(@NonNull ThomasListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean onEvent(@NonNull Event event) {
        Logger.verbose((String)"onEvent: %s", (Object[])new Object[]{event});
        switch (event.getType()) {
            case REPORTING_EVENT: {
                return this.onReportingEvent((ReportingEvent)event);
            }
        }
        return false;
    }

    private boolean onReportingEvent(ReportingEvent event) {
        switch (event.getReportType()) {
            case PAGE_VIEW: {
                ReportingEvent.PageView pageView = (ReportingEvent.PageView)event;
                this.listener.onPageView(pageView.getPagerData(), pageView.getState(), pageView.getDisplayedAt());
                return false;
            }
            case PAGE_SWIPE: {
                ReportingEvent.PageSwipe pageSwipe = (ReportingEvent.PageSwipe)event;
                this.listener.onPageSwipe(pageSwipe.getPagerData(), pageSwipe.getToPageIndex(), pageSwipe.getToPageId(), pageSwipe.getFromPageIndex(), pageSwipe.getFromPageId(), pageSwipe.getState());
                return false;
            }
            case BUTTON_TAP: {
                ReportingEvent.ButtonTap buttonTap = (ReportingEvent.ButtonTap)event;
                this.listener.onButtonTap(buttonTap.getButtonId(), buttonTap.getState());
                return false;
            }
            case OUTSIDE_DISMISS: {
                ReportingEvent.DismissFromOutside outsideDismiss = (ReportingEvent.DismissFromOutside)event;
                this.listener.onDismiss(outsideDismiss.getDisplayTime());
                return false;
            }
            case BUTTON_DISMISS: {
                ReportingEvent.DismissFromButton buttonDismiss = (ReportingEvent.DismissFromButton)event;
                this.listener.onDismiss(buttonDismiss.getButtonId(), buttonDismiss.getButtonDescription(), buttonDismiss.isCancel(), buttonDismiss.getDisplayTime(), buttonDismiss.getState());
                return false;
            }
            case FORM_RESULT: {
                ReportingEvent.FormResult formResult = (ReportingEvent.FormResult)event;
                this.listener.onFormResult(formResult.getFormData(), formResult.getState());
                return false;
            }
            case FORM_DISPLAY: {
                ReportingEvent.FormDisplay formDisplay = (ReportingEvent.FormDisplay)event;
                this.listener.onFormDisplay(formDisplay.getFormInfo(), formDisplay.getState());
                return false;
            }
        }
        return false;
    }
}

