/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import android.content.Context;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.graphics.Insets;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.android.layout.property.Size;
import com.urbanairship.android.layout.util.ResourceUtils;

public final class ConstraintSetBuilder {
    @NonNull
    public final ConstraintSet constraints;
    @NonNull
    private final Context context;

    private ConstraintSetBuilder(@NonNull Context context) {
        this(context, null);
    }

    private ConstraintSetBuilder(@NonNull Context context, @Nullable ConstraintSet constraints) {
        this.context = context;
        this.constraints = new ConstraintSet();
        if (constraints != null) {
            this.constraints.clone(constraints);
        }
    }

    @NonNull
    public static ConstraintSetBuilder newBuilder(@NonNull Context context) {
        return new ConstraintSetBuilder(context);
    }

    @NonNull
    public ConstraintSetBuilder constrainWithinParent(int viewId) {
        return this.constrainWithinParent(viewId, null);
    }

    @NonNull
    public ConstraintSetBuilder constrainWithinParent(int viewId, @Nullable Margin margin) {
        if (margin == null) {
            this.constraints.addToHorizontalChain(viewId, 0, 0);
            this.constraints.addToVerticalChain(viewId, 0, 0);
        } else {
            this.addToHorizontalChain(viewId, 0, 0, margin.getStart(), margin.getEnd());
            this.addToVerticalChain(viewId, 0, 0, margin.getTop(), margin.getBottom());
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder addToVerticalChain(int viewId, int topId, int bottomId, int marginTop, int marginBottom) {
        this.constraints.connect(viewId, 3, topId, topId == 0 ? 3 : 4, (int)ResourceUtils.dpToPx(this.context, marginTop));
        this.constraints.connect(viewId, 4, bottomId, bottomId == 0 ? 4 : 3, (int)ResourceUtils.dpToPx(this.context, marginBottom));
        if (topId != 0) {
            this.constraints.connect(topId, 4, viewId, 3, 0);
        }
        if (bottomId != 0) {
            this.constraints.connect(bottomId, 3, viewId, 4, 0);
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder addToHorizontalChain(int viewId, int leftId, int rightId, int leftMargin, int rightMargin) {
        this.constraints.connect(viewId, 1, leftId, leftId == 0 ? 1 : 2, (int)ResourceUtils.dpToPx(this.context, leftMargin));
        this.constraints.connect(viewId, 2, rightId, rightId == 0 ? 2 : 1, (int)ResourceUtils.dpToPx(this.context, rightMargin));
        if (leftId != 0) {
            this.constraints.connect(leftId, 2, viewId, 1, 0);
        }
        if (rightId != 0) {
            this.constraints.connect(rightId, 1, viewId, 2, 0);
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder setHorizontalChainStyle(@NonNull int[] viewIds, int chainStyle) {
        for (int i = 0; i < viewIds.length; ++i) {
            this.constraints.setHorizontalChainStyle(viewIds[i], chainStyle);
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder createHorizontalChainInParent(int[] viewIds, int verticalSpacing, int horizontalSpacing) {
        for (int i = 0; i < viewIds.length; ++i) {
            int viewId = viewIds[i];
            if (i == 0) {
                this.addToHorizontalChain(viewId, 0, viewIds[i + 1], 0, horizontalSpacing);
            } else if (i == viewIds.length - 1) {
                this.addToHorizontalChain(viewId, viewIds[i - 1], 0, horizontalSpacing, 0);
            } else {
                this.addToHorizontalChain(viewId, viewIds[i - 1], viewIds[i + 1], horizontalSpacing, horizontalSpacing);
            }
            this.addToVerticalChain(viewId, 0, 0, verticalSpacing, verticalSpacing);
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder squareAspectRatio(int viewId) {
        this.constraints.setDimensionRatio(viewId, "1:1");
        return this;
    }

    @NonNull
    public ConstraintSetBuilder minHeight(int viewId, int minHeight) {
        this.constraints.constrainMinHeight(viewId, (int)ResourceUtils.dpToPx(this.context, minHeight));
        return this;
    }

    @NonNull
    public ConstraintSetBuilder size(@Nullable Size size, @IdRes int viewId) {
        return this.size(size, viewId, -2);
    }

    @NonNull
    public ConstraintSetBuilder size(@Nullable Size size, @IdRes int viewId, int autoValue) {
        if (size != null) {
            Size.Dimension width = size.getWidth();
            switch (width.getType()) {
                case AUTO: {
                    this.constraints.constrainWidth(viewId, autoValue);
                    break;
                }
                case PERCENT: {
                    if (width.getFloat() == 1.0f) {
                        this.constraints.constrainWidth(viewId, 0);
                        break;
                    }
                    this.constraints.constrainPercentWidth(viewId, width.getFloat());
                    break;
                }
                case ABSOLUTE: {
                    this.constraints.constrainWidth(viewId, (int)ResourceUtils.dpToPx(this.context, width.getInt()));
                }
            }
            Size.Dimension height = size.getHeight();
            switch (height.getType()) {
                case AUTO: {
                    this.constraints.constrainHeight(viewId, autoValue);
                    break;
                }
                case PERCENT: {
                    if (height.getFloat() == 1.0f) {
                        this.constraints.constrainHeight(viewId, 0);
                        break;
                    }
                    this.constraints.constrainPercentHeight(viewId, height.getFloat());
                    break;
                }
                case ABSOLUTE: {
                    this.constraints.constrainHeight(viewId, (int)ResourceUtils.dpToPx(this.context, height.getInt()));
                }
            }
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder position(@Nullable Position position, @IdRes int viewId) {
        if (position != null) {
            this.constrainWithinParent(viewId);
            switch (position.getHorizontal()) {
                case START: {
                    this.constraints.setHorizontalBias(viewId, 0.0f);
                    break;
                }
                case END: {
                    this.constraints.setHorizontalBias(viewId, 1.0f);
                    break;
                }
                case CENTER: {
                    this.constraints.setHorizontalBias(viewId, 0.5f);
                }
            }
            switch (position.getVertical()) {
                case TOP: {
                    this.constraints.setVerticalBias(viewId, 0.0f);
                    break;
                }
                case BOTTOM: {
                    this.constraints.setVerticalBias(viewId, 1.0f);
                    break;
                }
                case CENTER: {
                    this.constraints.setVerticalBias(viewId, 0.5f);
                }
            }
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder margin(@Nullable Margin margin, @IdRes int viewId) {
        if (margin != null) {
            this.constraints.setMargin(viewId, 3, (int)ResourceUtils.dpToPx(this.context, margin.getTop()));
            this.constraints.setMargin(viewId, 4, (int)ResourceUtils.dpToPx(this.context, margin.getBottom()));
            this.constraints.setMargin(viewId, 6, (int)ResourceUtils.dpToPx(this.context, margin.getStart()));
            this.constraints.setMargin(viewId, 7, (int)ResourceUtils.dpToPx(this.context, margin.getEnd()));
        }
        return this;
    }

    @NonNull
    public ConstraintSetBuilder margin(@Nullable Margin margin, @NonNull Insets insets, @IdRes int viewId) {
        if (margin == null) {
            margin = new Margin(0, 0, 0, 0);
        }
        this.constraints.setMargin(viewId, 3, (int)ResourceUtils.dpToPx(this.context, margin.getTop()) + insets.top);
        this.constraints.setMargin(viewId, 4, (int)ResourceUtils.dpToPx(this.context, margin.getBottom()) + insets.bottom);
        this.constraints.setMargin(viewId, 6, (int)ResourceUtils.dpToPx(this.context, margin.getStart()) + insets.left);
        this.constraints.setMargin(viewId, 7, (int)ResourceUtils.dpToPx(this.context, margin.getEnd()) + insets.right);
        return this;
    }

    @NonNull
    public ConstraintSet build() {
        return this.constraints;
    }
}

