/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.urbanairship.Fonts;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.LabelButtonModel;
import com.urbanairship.android.layout.model.LabelModel;
import com.urbanairship.android.layout.model.TextInputModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.FormInputType;
import com.urbanairship.android.layout.property.SwitchStyle;
import com.urbanairship.android.layout.property.TextAppearance;
import com.urbanairship.android.layout.property.TextStyle;
import com.urbanairship.android.layout.util.ColorStateListBuilder;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.widget.Clippable;
import com.urbanairship.util.UAStringUtil;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class LayoutUtils {
    private static final float PRESSED_ALPHA_PERCENT = 0.2f;
    private static final int DEFAULT_STROKE_WIDTH_DPS = 2;
    private static final int DEFAULT_BORDER_RADIUS = 0;
    private static final float MATERIAL_ALPHA_FULL = 1.0f;
    private static final float MATERIAL_ALPHA_LOW = 0.32f;
    private static final float MATERIAL_ALPHA_DISABLED = 0.38f;
    private static final String NBSP = "\u00a0";
    private static final String NARROW_NBSP = "\u202f";

    private LayoutUtils() {
    }

    public static void applyBorderAndBackground(@NonNull View view, @NonNull BaseModel model) {
        LayoutUtils.applyBorderAndBackground(view, model.getBorder(), model.getBackgroundColor());
    }

    public static void applyBorderAndBackground(@NonNull View view, @Nullable Border border, @Nullable Color backgroundColor) {
        Context context = view.getContext();
        if (border != null) {
            float cornerRadius = border.getRadius() == null ? 0.0f : ResourceUtils.dpToPx(context, border.getRadius());
            ShapeAppearanceModel shapeModel = ShapeAppearanceModel.builder().setAllCorners(0, cornerRadius).build();
            MaterialShapeDrawable shapeDrawable = new MaterialShapeDrawable(shapeModel);
            if (view instanceof Clippable) {
                ((Clippable)view).setClipPathBorderRadius(cornerRadius);
            }
            int borderPadding = -1;
            if (border.getStrokeWidth() != null) {
                float strokeWidth = ResourceUtils.dpToPx(context, border.getStrokeWidth());
                shapeDrawable.setStrokeWidth(strokeWidth);
                borderPadding = (int)strokeWidth;
            }
            if (border.getStrokeColor() != null) {
                shapeDrawable.setStrokeColor(ColorStateList.valueOf((int)border.getStrokeColor().resolve(context)));
            }
            int fillColor = backgroundColor != null ? backgroundColor.resolve(context) : 0;
            shapeDrawable.setFillColor(ColorStateList.valueOf((int)fillColor));
            LayoutUtils.mergeBackground(view, (Drawable)shapeDrawable);
            if (borderPadding > -1) {
                LayoutUtils.addPadding(view, borderPadding);
            }
        } else if (backgroundColor != null) {
            LayoutUtils.mergeBackground(view, (Drawable)new ColorDrawable(backgroundColor.resolve(context)));
        }
    }

    public static void resetBorderAndBackground(@NonNull View view) {
        view.setBackground(null);
        view.setPadding(0, 0, 0, 0);
        if (view instanceof Clippable) {
            ((Clippable)view).setClipPathBorderRadius(0.0f);
        }
    }

    private static void mergeBackground(@NonNull View view, @NonNull Drawable drawable2) {
        Drawable background = drawable2;
        if (view.getBackground() != null) {
            background = new LayerDrawable(new Drawable[]{view.getBackground(), drawable2});
        }
        view.setBackground(background);
    }

    public static void applyButtonModel(@NonNull MaterialButton button, @NonNull LabelButtonModel model) {
        LayoutUtils.applyLabelModel((TextView)button, model.getLabel());
        Context context = button.getContext();
        TextAppearance textAppearance = model.getLabel().getTextAppearance();
        int textColor = textAppearance.getColor().resolve(context);
        int backgroundColor = model.getBackgroundColor() == null ? 0 : model.getBackgroundColor().resolve(button.getContext());
        int pressedColor = ColorUtils.setAlphaComponent((int)textColor, (int)Math.round(Color.alpha(textColor) * 0.2f));
        int disabledColor = LayoutUtils.generateDisabledColor(backgroundColor);
        int strokeWidth = model.getBorder() == null || model.getBorder().getStrokeWidth() == null ? 2 : model.getBorder().getStrokeWidth();
        int strokeColor = model.getBorder() == null || model.getBorder().getStrokeColor() == null ? backgroundColor : model.getBorder().getStrokeColor().resolve(context);
        int disabledStrokeColor = LayoutUtils.generateDisabledColor(strokeColor);
        int borderRadius = model.getBorder() == null || model.getBorder().getRadius() == null ? 0 : model.getBorder().getRadius();
        button.setBackgroundTintList(new ColorStateListBuilder().add(disabledColor, -16842910).add(backgroundColor).build());
        button.setRippleColor(ColorStateList.valueOf((int)pressedColor));
        int strokeWidthDp = (int)ResourceUtils.dpToPx(context, strokeWidth);
        button.setStrokeWidth(strokeWidthDp);
        if (strokeWidthDp > 0) {
            LayoutUtils.addPadding((View)button, strokeWidthDp);
        }
        button.setStrokeColor(new ColorStateListBuilder().add(disabledStrokeColor, -16842910).add(strokeColor).build());
        button.setCornerRadius((int)ResourceUtils.dpToPx(context, borderRadius));
    }

    public static void applyLabelModel(@NonNull TextView textView, @NonNull LabelModel label) {
        TextAppearance appearance = label.getTextAppearance();
        String text = label.getText();
        LayoutUtils.applyTextAppearance(textView, appearance);
        Fonts fonts = Fonts.shared((Context)textView.getContext());
        boolean isCustomFont = false;
        for (String font : appearance.getFontFamilies()) {
            if (fonts.isSystemFont(font)) continue;
            isCustomFont = true;
            break;
        }
        boolean isItalic = appearance.getTextStyles().contains((Object)TextStyle.ITALIC);
        if (isCustomFont && isItalic) {
            text = text + NBSP;
        } else if (isCustomFont || isItalic) {
            text = text + NARROW_NBSP;
        }
        textView.setText((CharSequence)text);
    }

    public static void applyTextInputModel(@NonNull AppCompatEditText editText, @NonNull TextInputModel textInput) {
        LayoutUtils.applyBorderAndBackground((View)editText, textInput);
        LayoutUtils.applyTextAppearance((TextView)editText, textInput.getTextAppearance());
        int padding = (int)ResourceUtils.dpToPx(editText.getContext(), 8);
        editText.setPadding(padding, padding, padding, padding);
        editText.setInputType(textInput.getInputType().getTypeMask());
        editText.setSingleLine(textInput.getInputType() != FormInputType.TEXT_MULTILINE);
        editText.setGravity(editText.getGravity() | 0x30);
        if (!UAStringUtil.isEmpty((String)textInput.getHintText())) {
            editText.setHint((CharSequence)textInput.getHintText());
            Color hintColor = textInput.getTextAppearance().getHintColor();
            if (hintColor != null) {
                editText.setHintTextColor(hintColor.resolve(editText.getContext()));
            }
        }
        if (!UAStringUtil.isEmpty((String)textInput.getContentDescription())) {
            editText.setContentDescription((CharSequence)textInput.getContentDescription());
        }
    }

    public static void applyTextAppearance(@NonNull TextView textView, @NonNull TextAppearance textAppearance) {
        Context context = textView.getContext();
        textView.setTextSize((float)textAppearance.getFontSize());
        int textColor = textAppearance.getColor().resolve(context);
        int disabledTextColor = LayoutUtils.generateDisabledColor(0, textColor);
        textView.setTextColor(new ColorStateListBuilder().add(disabledTextColor, -16842910).add(textColor).build());
        int typefaceFlags = 0;
        int paintFlags = 129;
        for (TextStyle style : textAppearance.getTextStyles()) {
            switch (style) {
                case BOLD: {
                    typefaceFlags |= 1;
                    break;
                }
                case ITALIC: {
                    typefaceFlags |= 2;
                    break;
                }
                case UNDERLINE: {
                    paintFlags |= 8;
                }
            }
        }
        switch (textAppearance.getAlignment()) {
            case CENTER: {
                textView.setGravity(17);
                break;
            }
            case START: {
                textView.setGravity(8388627);
                break;
            }
            case END: {
                textView.setGravity(8388629);
            }
        }
        Typeface typeface = LayoutUtils.getTypeFace(textView.getContext(), textAppearance.getFontFamilies());
        textView.setTypeface(typeface, typefaceFlags);
        textView.setPaintFlags(paintFlags);
    }

    @Nullable
    private static Typeface getTypeFace(@NonNull Context context, @NonNull List<String> fontFamilies) {
        for (String fontFamily : fontFamilies) {
            Typeface typeface;
            if (UAStringUtil.isEmpty((String)fontFamily) || (typeface = Fonts.shared((Context)context).getFontFamily(fontFamily)) == null) continue;
            return typeface;
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void applySwitchStyle(@NonNull SwitchCompat view, @NonNull SwitchStyle style) {
        Context context = view.getContext();
        int trackOn = style.getOnColor().resolve(context);
        int trackOff = style.getOffColor().resolve(context);
        int thumbOn = MaterialColors.layer((int)-1, (int)trackOn, (float)0.32f);
        int thumbOff = MaterialColors.layer((int)-1, (int)trackOff, (float)0.32f);
        view.setTrackTintList(LayoutUtils.checkedColorStateList(trackOn, trackOff));
        view.setThumbTintList(LayoutUtils.checkedColorStateList(thumbOn, thumbOff));
        view.setBackgroundResource(R.drawable.ua_layout_imagebutton_ripple);
        view.setGravity(17);
    }

    private static ColorStateList checkedColorStateList(@ColorInt int checkedColor, @ColorInt int normalColor) {
        return new ColorStateListBuilder().add(checkedColor, 0x10100A0).add(normalColor).build();
    }

    public static void doOnAttachToWindow(@NonNull View view, final @NonNull Runnable callback) {
        view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                callback.run();
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
    }

    public static void addPadding(@NonNull View view, int padding) {
        LayoutUtils.addPadding(view, padding, padding, padding, padding);
    }

    public static void addPadding(@NonNull View view, int left, int top, int right, int bottom) {
        view.setPadding(view.getPaddingLeft() + left, view.getPaddingTop() + top, view.getPaddingRight() + right, view.getPaddingBottom() + bottom);
    }

    @ColorInt
    public static int generatePressedColor(@ColorInt int baseColor) {
        return LayoutUtils.generatePressedColor(baseColor, -1);
    }

    @ColorInt
    public static int generateDisabledColor(@ColorInt int baseColor) {
        return LayoutUtils.generateDisabledColor(baseColor, -1);
    }

    @ColorInt
    public static int generatePressedColor(@ColorInt int background, @ColorInt int foreground) {
        return LayoutUtils.overlayColors(background, foreground, 0.2f);
    }

    @ColorInt
    public static int generateDisabledColor(@ColorInt int background, @ColorInt int foreground) {
        return LayoutUtils.overlayColors(background, foreground, 0.38f);
    }

    @ColorInt
    private static int overlayColors(@ColorInt int backgroundColor, @ColorInt int overlayColor, @FloatRange(from=0.0, to=1.0) float overlayAlpha) {
        int alpha = Math.round(Color.alpha(overlayColor) * overlayAlpha);
        int overlay = ColorUtils.setAlphaComponent((int)overlayColor, (int)alpha);
        return ColorUtils.compositeColors((int)overlay, (int)backgroundColor);
    }
}

