/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ImageButtonModel;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.model.MediaModel;
import com.urbanairship.android.layout.model.WebViewModel;
import com.urbanairship.android.layout.property.Image;
import java.util.ArrayList;
import java.util.List;

public class UrlInfo {
    @NonNull
    private final UrlType type;
    @NonNull
    private final String url;

    UrlInfo(@NonNull UrlType type, @NonNull String url) {
        this.type = type;
        this.url = url;
    }

    @NonNull
    public UrlType getType() {
        return this.type;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public static List<UrlInfo> from(@NonNull BaseModel model) {
        ArrayList<UrlInfo> urlInfos = new ArrayList<UrlInfo>();
        switch (model.getType()) {
            case MEDIA: {
                MediaModel mediaModel = (MediaModel)model;
                switch (mediaModel.getMediaType()) {
                    case IMAGE: {
                        urlInfos.add(new UrlInfo(UrlType.IMAGE, mediaModel.getUrl()));
                        break;
                    }
                    case VIDEO: 
                    case YOUTUBE: {
                        urlInfos.add(new UrlInfo(UrlType.VIDEO, mediaModel.getUrl()));
                    }
                }
                break;
            }
            case IMAGE_BUTTON: {
                ImageButtonModel imageButtonModel = (ImageButtonModel)model;
                if (imageButtonModel.getImage().getType() != Image.Type.URL) break;
                String url = ((Image.Url)imageButtonModel.getImage()).getUrl();
                urlInfos.add(new UrlInfo(UrlType.IMAGE, url));
                break;
            }
            case WEB_VIEW: {
                WebViewModel webViewModel = (WebViewModel)model;
                urlInfos.add(new UrlInfo(UrlType.WEB_PAGE, webViewModel.getUrl()));
            }
        }
        if (model instanceof LayoutModel) {
            for (BaseModel child : ((LayoutModel)model).getChildren()) {
                urlInfos.addAll(UrlInfo.from(child));
            }
        }
        return urlInfos;
    }

    public static enum UrlType {
        WEB_PAGE,
        IMAGE,
        VIDEO;

    }
}

