/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.ContainerLayoutModel;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.ClippableConstraintLayout;
import java.util.List;

public class ContainerLayoutView
extends ClippableConstraintLayout
implements BaseView<ContainerLayoutModel> {
    private ContainerLayoutModel model;
    private Environment environment;
    private final SparseBooleanArray frameShouldIgnoreSafeArea = new SparseBooleanArray();
    private final SparseArray<Margin> frameMargins = new SparseArray();

    public ContainerLayoutView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public ContainerLayoutView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ContainerLayoutView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        this.setClipChildren(true);
    }

    @NonNull
    public static ContainerLayoutView create(@NonNull Context context, @NonNull ContainerLayoutModel model, @NonNull Environment environment) {
        ContainerLayoutView view = new ContainerLayoutView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull ContainerLayoutModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configureContainer();
    }

    private void configureContainer() {
        List<ContainerLayoutModel.Item> items = this.model.getItems();
        ConstraintSetBuilder constraintBuilder = ConstraintSetBuilder.newBuilder(this.getContext());
        this.addItems(items, constraintBuilder);
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        constraintBuilder.build().applyTo((ConstraintLayout)this);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new WindowInsetsListener(constraintBuilder));
    }

    private void addItems(@NonNull List<ContainerLayoutModel.Item> items, @NonNull ConstraintSetBuilder constraintBuilder) {
        for (ContainerLayoutModel.Item item : items) {
            this.addItem(constraintBuilder, item);
        }
    }

    private void addItem(@NonNull ConstraintSetBuilder constraintBuilder, @NonNull ContainerLayoutModel.Item item) {
        View itemView = Thomas.view(this.getContext(), item.getView(), this.environment);
        FrameLayout frame = new FrameLayout(this.getContext());
        int frameId = ContainerLayoutView.generateViewId();
        frame.setId(frameId);
        frame.addView(itemView, -1, -1);
        this.addView((View)frame);
        constraintBuilder.position(item.getPosition(), frameId).size(item.getSize(), frameId).margin(item.getMargin(), frameId);
        this.frameShouldIgnoreSafeArea.put(frameId, item.shouldIgnoreSafeArea());
        this.frameMargins.put(frameId, (Object)(item.getMargin() != null ? item.getMargin() : Margin.NONE));
    }

    private class WindowInsetsListener
    implements OnApplyWindowInsetsListener {
        private final ConstraintSetBuilder constraintBuilder;

        public WindowInsetsListener(ConstraintSetBuilder constraintBuilder) {
            this.constraintBuilder = constraintBuilder;
        }

        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat windowInsets) {
            WindowInsetsCompat applied = ViewCompat.onApplyWindowInsets((View)v, (WindowInsetsCompat)windowInsets);
            Insets insets = applied.getInsets(WindowInsetsCompat.Type.systemBars());
            if (applied.isConsumed() || insets.equals((Object)Insets.NONE)) {
                return WindowInsetsCompat.CONSUMED;
            }
            boolean constraintsChanged = false;
            for (int i = 0; i < ContainerLayoutView.this.getChildCount(); ++i) {
                ViewGroup child = (ViewGroup)ContainerLayoutView.this.getChildAt(i);
                boolean shouldIgnoreSafeArea = ContainerLayoutView.this.frameShouldIgnoreSafeArea.get(child.getId(), false);
                if (shouldIgnoreSafeArea) {
                    ViewCompat.dispatchApplyWindowInsets((View)child, (WindowInsetsCompat)applied);
                    continue;
                }
                ViewCompat.dispatchApplyWindowInsets((View)child, (WindowInsetsCompat)applied.inset(insets));
                Margin margin = (Margin)ContainerLayoutView.this.frameMargins.get(child.getId());
                this.constraintBuilder.margin(margin, insets, child.getId());
                constraintsChanged = true;
            }
            if (constraintsChanged) {
                this.constraintBuilder.build().applyTo((ConstraintLayout)ContainerLayoutView.this);
            }
            return applied.inset(insets);
        }
    }
}

