/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.urbanairship.Logger;
import com.urbanairship.UAirship;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.MediaModel;
import com.urbanairship.android.layout.property.MediaType;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.images.ImageRequestOptions;
import com.urbanairship.util.ManifestUtils;
import com.urbanairship.util.UAStringUtil;
import java.lang.ref.WeakReference;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MediaView
extends FrameLayout
implements BaseView<MediaModel> {
    private MediaModel model;
    private Environment environment;
    @Nullable
    private WebView webView;
    private static final String VIDEO_HTML_FORMAT = "<body style=\"margin:0\"><video playsinline controls height=\"100%%\" width=\"100%%\" src=\"%s\"></video></body>";
    private static final String IMAGE_HTML_FORMAT = "<body style=\"margin:0\"><img height=\"100%%\" width=\"100%%\" src=\"%s\"/></body>";
    private final LifecycleObserver lifecycleListener = new DefaultLifecycleObserver(){

        public void onPause(@NonNull LifecycleOwner owner) {
            if (MediaView.this.webView != null) {
                MediaView.this.webView.onPause();
            }
        }

        public void onResume(@NonNull LifecycleOwner owner) {
            if (MediaView.this.webView != null) {
                MediaView.this.webView.onResume();
            }
        }
    };

    public MediaView(@NonNull Context context) {
        this(context, null);
        this.init();
    }

    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        this.init();
    }

    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
    }

    @NonNull
    public static MediaView create(@NonNull Context context, @NonNull MediaModel model, @NonNull Environment environment) {
        MediaView view = new MediaView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull MediaModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configure();
    }

    private void configure() {
        this.removeAllViewsInLayout();
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        if (this.webView != null) {
            this.webView.stopLoading();
            this.webView.setWebChromeClient(null);
            this.webView.setWebViewClient(null);
            this.webView.destroy();
            this.webView = null;
        }
        switch (this.model.getMediaType()) {
            case IMAGE: {
                this.configureImage(this.model);
                break;
            }
            case VIDEO: 
            case YOUTUBE: {
                this.configureVideo(this.model);
            }
        }
    }

    private void configureImage(@NonNull MediaModel model) {
        String url = model.getUrl();
        String cachedImage = this.environment.imageCache().get(url);
        if (cachedImage != null) {
            url = cachedImage;
        }
        if (url.endsWith(".svg")) {
            this.configureVideo(model);
            return;
        }
        ImageView imageView = new ImageView(this.getContext());
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(model.getScaleType());
        if (!UAStringUtil.isEmpty((String)model.getContentDescription())) {
            imageView.setContentDescription((CharSequence)model.getContentDescription());
        }
        this.addView((View)imageView);
        int fallbackWidth = ResourceUtils.getDisplayWidthPixels(this.getContext());
        int fallbackHeight = ResourceUtils.getDisplayHeightPixels(this.getContext());
        ImageRequestOptions options = ImageRequestOptions.newBuilder((String)url).setFallbackDimensions(fallbackWidth, fallbackHeight).build();
        UAirship.shared().getImageLoader().load(this.getContext(), imageView, options);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void configureVideo(@NonNull MediaModel model) {
        int width = 16;
        int height = 9;
        this.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            if (params.height == -2) {
                float scale = (float)this.getWidth() / (float)width;
                params.height = Math.round(scale * (float)height);
            } else {
                float imageRatio = (float)width / (float)height;
                float viewRatio = (float)this.getWidth() / (float)this.getHeight();
                if (imageRatio >= viewRatio) {
                    params.height = Math.round((float)this.getWidth() / imageRatio);
                } else {
                    int w = Math.round((float)this.getHeight() * imageRatio);
                    params.width = w > 0 ? w : -1;
                }
            }
            this.setLayoutParams(params);
        });
        this.environment.lifecycle().addObserver(this.lifecycleListener);
        this.webView = new WebView(this.getContext());
        this.webView.setWebChromeClient(this.environment.webChromeClientFactory().create());
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout.LayoutParams webViewLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        webViewLayoutParams.gravity = 17;
        frameLayout.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLayoutParams);
        final ProgressBar progressBar = new ProgressBar(this.getContext());
        progressBar.setIndeterminate(true);
        progressBar.setId(16908301);
        FrameLayout.LayoutParams progressBarLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        progressBarLayoutParams.gravity = 17;
        frameLayout.addView((View)progressBar, (ViewGroup.LayoutParams)progressBarLayoutParams);
        WebSettings settings = this.webView.getSettings();
        if (model.getMediaType() == MediaType.VIDEO) {
            settings.setMediaPlaybackRequiresUserGesture(true);
        }
        settings.setJavaScriptEnabled(true);
        if (ManifestUtils.shouldEnableLocalStorage()) {
            settings.setDomStorageEnabled(true);
            settings.setDatabaseEnabled(true);
        }
        WeakReference<WebView> webViewWeakReference = new WeakReference<WebView>(this.webView);
        Runnable load = () -> {
            WebView webView = (WebView)webViewWeakReference.get();
            if (webView == null) {
                return;
            }
            switch (model.getMediaType()) {
                case VIDEO: {
                    webView.loadData(String.format(Locale.ROOT, VIDEO_HTML_FORMAT, model.getUrl()), "text/html", "UTF-8");
                    break;
                }
                case IMAGE: {
                    webView.loadData(String.format(Locale.ROOT, IMAGE_HTML_FORMAT, model.getUrl()), "text/html", "UTF-8");
                    break;
                }
                default: {
                    webView.loadUrl(model.getUrl());
                }
            }
        };
        if (!UAStringUtil.isEmpty((String)model.getContentDescription())) {
            this.webView.setContentDescription((CharSequence)model.getContentDescription());
        }
        this.webView.setVisibility(4);
        this.webView.setWebViewClient((WebViewClient)new MediaWebViewClient(load){

            @Override
            protected void onPageFinished(@NonNull WebView webView) {
                webView.setVisibility(0);
                progressBar.setVisibility(8);
            }
        });
        this.addView((View)frameLayout);
        if (!UAirship.shared().getUrlAllowList().isAllowed(model.getUrl(), 2)) {
            Logger.error((String)"URL not allowed. Unable to load: %s", (Object[])new Object[]{model.getUrl()});
            return;
        }
        load.run();
    }

    private static abstract class MediaWebViewClient
    extends WebViewClient {
        static final long START_RETRY_DELAY = 1000L;
        @NonNull
        private final Runnable onRetry;
        boolean error = false;
        long retryDelay = 1000L;

        private MediaWebViewClient(@NonNull Runnable onRetry) {
            this.onRetry = onRetry;
        }

        public void onPageFinished(@NonNull WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.error) {
                view.postDelayed(this.onRetry, this.retryDelay);
                this.retryDelay *= 2L;
            } else {
                this.onPageFinished(view);
            }
            this.error = false;
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            this.error = true;
        }

        protected abstract void onPageFinished(WebView var1);
    }
}

