/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ModalPresentation;
import com.urbanairship.android.layout.property.ConstrainedSize;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.ModalPlacement;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.widget.ConstrainedFrameLayout;

public class ModalView
extends ConstraintLayout {
    private BaseModel model;
    private ModalPresentation presentation;
    private Environment environment;
    private ConstrainedFrameLayout modalFrame;
    private View containerView;
    private int windowTouchSlop;
    @Nullable
    private View.OnClickListener clickOutsideListener = null;

    public ModalView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ModalView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ModalView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void init(@NonNull Context context) {
        this.windowTouchSlop = ViewConfiguration.get((Context)context).getScaledWindowTouchSlop();
    }

    @NonNull
    public static ModalView create(@NonNull Context context, @NonNull BaseModel model, @NonNull ModalPresentation presentation, @NonNull Environment environment) {
        ModalView view = new ModalView(context);
        view.setModal(model, presentation, environment);
        return view;
    }

    public void setModal(@NonNull BaseModel model, @NonNull ModalPresentation presentation, @NonNull Environment environment) {
        this.model = model;
        this.presentation = presentation;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configureModal();
    }

    public void configureModal() {
        ModalPlacement placement = this.presentation.getResolvedPlacement(this.getContext());
        ConstrainedSize size = placement.getSize();
        Position position = placement.getPosition();
        Margin margin = placement.getMargin();
        Integer shadeColor = placement.getShadeColor() != null ? Integer.valueOf(placement.getShadeColor().resolve(this.getContext())) : null;
        this.makeFrame(size);
        this.containerView = Thomas.view(this.getContext(), this.model, this.environment);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        int n = lp.gravity = position != null ? position.getGravity() : 17;
        if (margin != null) {
            lp.setMargins(margin.getStart(), margin.getTop(), margin.getEnd(), margin.getBottom());
        }
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.modalFrame.addView(this.containerView);
        this.addView((View)this.modalFrame);
        int viewId = this.modalFrame.getId();
        ConstraintSet constraints = ConstraintSetBuilder.newBuilder(this.getContext()).constrainWithinParent(viewId).size(size, viewId).margin(margin, viewId).build();
        if (shadeColor != null) {
            this.setBackgroundColor(shadeColor);
        }
        constraints.applyTo((ConstraintLayout)this);
        if (this.environment.isIgnoringSafeAreas()) {
            ViewCompat.setOnApplyWindowInsetsListener((View)this.modalFrame, (v, insets) -> ViewCompat.dispatchApplyWindowInsets((View)this.containerView, (WindowInsetsCompat)insets));
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public void makeFrame(ConstrainedSize size) {
        this.modalFrame = new ConstrainedFrameLayout(this.getContext(), size);
        this.modalFrame.setId(ModalView.generateViewId());
        ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(0, 0);
        this.modalFrame.setLayoutParams((ViewGroup.LayoutParams)params);
        this.modalFrame.setElevation(ResourceUtils.dpToPx(this.getContext(), 16));
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                return true;
            }
            case 1: {
                if (!this.isTouchOutside(event) || this.clickOutsideListener == null) break;
                this.clickOutsideListener.onClick((View)this);
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public void setOnClickOutsideListener(View.OnClickListener listener) {
        this.clickOutsideListener = listener;
    }

    private boolean isTouchOutside(@NonNull MotionEvent event) {
        Rect r = new Rect();
        this.containerView.getHitRect(r);
        r.inset(-this.windowTouchSlop, -this.windowTouchSlop);
        return !r.contains((int)event.getX(), (int)event.getY());
    }
}

