/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.ScoreModel;
import com.urbanairship.android.layout.property.ScoreStyle;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.ShapeButton;
import com.urbanairship.util.UAStringUtil;
import java.util.Objects;

public class ScoreView
extends ConstraintLayout
implements BaseView<ScoreModel> {
    private ScoreModel model;
    @Nullable
    private Integer selectedScore = null;
    private final SparseIntArray scoreToViewIds = new SparseIntArray();

    public ScoreView(Context context) {
        super(context);
        this.init();
    }

    public ScoreView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ScoreView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    @NonNull
    public static ScoreView create(@NonNull Context context, @NonNull ScoreModel model, Environment environment) {
        ScoreView view = new ScoreView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull ScoreModel model, @NonNull Environment environment) {
        this.model = model;
        this.setId(model.getViewId());
        this.configure();
    }

    private void configure() {
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        ConstraintSetBuilder constraints = ConstraintSetBuilder.newBuilder(this.getContext());
        ScoreStyle style = this.model.getStyle();
        switch (style.getType()) {
            case NUMBER_RANGE: {
                this.configureNumberRange((ScoreStyle.NumberRange)style, constraints);
            }
        }
        if (!UAStringUtil.isEmpty((String)this.model.getContentDescription())) {
            this.setContentDescription(this.model.getContentDescription());
        }
        constraints.build().applyTo((ConstraintLayout)this);
        if (this.model.getSelectedScore() != null) {
            this.setSelectedScore(this.model.getSelectedScore());
        }
        this.model.onConfigured();
        LayoutUtils.doOnAttachToWindow((View)this, this.model::onAttachedToWindow);
    }

    private void configureNumberRange(@NonNull ScoreStyle.NumberRange style, @NonNull ConstraintSetBuilder constraints) {
        ScoreStyle.Bindings bindings = style.getBindings();
        int start = style.getStart();
        int end = style.getEnd();
        int[] viewIds = new int[end - start + 1];
        for (int i = start; i <= end; ++i) {
            int score = i;
            ShapeButton button = new ShapeButton(this.getContext(), bindings.getSelected().getShapes(), bindings.getUnselected().getShapes(), String.valueOf(score), bindings.getSelected().getTextAppearance(), bindings.getUnselected().getTextAppearance()){

                @Override
                public void toggle() {
                }
            };
            int viewId = ScoreView.generateViewId();
            button.setId(viewId);
            viewIds[i - start] = viewId;
            this.scoreToViewIds.append(score, viewId);
            button.setOnClickListener(v -> this.onScoreClick(v, score));
            constraints.squareAspectRatio(viewId);
            constraints.minHeight(viewId, 16);
            this.addView((View)button, (ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(0, 0));
        }
        constraints.setHorizontalChainStyle(viewIds, 2).createHorizontalChainInParent(viewIds, 0, style.getSpacing());
    }

    private void setSelectedScore(int score) {
        View view;
        this.selectedScore = score;
        int viewId = this.scoreToViewIds.get(score, -1);
        if (viewId > -1 && (view = this.findViewById(viewId)) instanceof Checkable) {
            ((Checkable)view).setChecked(true);
        }
    }

    private void onScoreClick(@NonNull View view, int score) {
        if (Objects.equals(score, this.selectedScore)) {
            return;
        }
        this.selectedScore = score;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof Checkable)) continue;
            ((Checkable)child).setChecked(view.getId() == child.getId());
        }
        this.model.onScoreChange(score);
    }
}

