/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.widget.NestedScrollView;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.ScrollLayoutModel;
import com.urbanairship.android.layout.property.Direction;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;

public class ScrollLayoutView
extends NestedScrollView
implements BaseView<ScrollLayoutModel> {
    private ScrollLayoutModel model;
    private Environment environment;

    public ScrollLayoutView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public ScrollLayoutView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ScrollLayoutView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setFillViewport(false);
    }

    @NonNull
    public static ScrollLayoutView create(@NonNull Context context, @NonNull ScrollLayoutModel model, @NonNull Environment environment) {
        ScrollLayoutView view = new ScrollLayoutView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull ScrollLayoutModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configureScrollLayout();
    }

    private void configureScrollLayout() {
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        Direction direction = this.model.getDirection();
        View contentView = Thomas.view(this.getContext(), this.model.getView(), this.environment);
        FrameLayout.LayoutParams layoutParams = direction == Direction.VERTICAL ? new FrameLayout.LayoutParams(-1, -2) : new FrameLayout.LayoutParams(-2, -1);
        this.setClipToOutline(true);
        contentView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView(contentView);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (v, insets) -> ViewCompat.dispatchApplyWindowInsets((View)contentView, (WindowInsetsCompat)insets));
    }
}

