/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.urbanairship.Logger;
import com.urbanairship.UAirship;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.WebViewModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.util.ManifestUtils;
import com.urbanairship.webkit.AirshipWebView;
import com.urbanairship.webkit.AirshipWebViewClient;
import java.lang.ref.WeakReference;

public class WebViewView
extends FrameLayout
implements BaseView<WebViewModel> {
    private WebViewModel model;
    private Environment environment;
    @Nullable
    private WebView webView;
    @Nullable
    private WebChromeClient chromeClient;
    private final LifecycleObserver lifecycleListener = new DefaultLifecycleObserver(){

        public void onPause(@NonNull LifecycleOwner owner) {
            if (WebViewView.this.webView != null) {
                WebViewView.this.webView.onPause();
            }
        }

        public void onResume(@NonNull LifecycleOwner owner) {
            if (WebViewView.this.webView != null) {
                WebViewView.this.webView.onResume();
            }
        }

        public void onStop(@NonNull LifecycleOwner owner) {
            if (WebViewView.this.webView != null) {
                Bundle bundle = new Bundle();
                WebViewView.this.webView.saveState(bundle);
                WebViewView.this.model.saveState(bundle);
            }
        }
    };

    public WebViewView(@NonNull Context context) {
        this(context, null);
        this.init();
    }

    public WebViewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        this.init();
    }

    public WebViewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
    }

    @NonNull
    public static WebViewView create(@NonNull Context context, @NonNull WebViewModel model, Environment environment) {
        WebViewView view = new WebViewView(context);
        view.setModel(model, environment);
        return view;
    }

    public void setChromeClient(@Nullable WebChromeClient chromeClient) {
        this.chromeClient = chromeClient;
        if (this.webView != null) {
            this.webView.setWebChromeClient(chromeClient);
        }
    }

    @Override
    public void setModel(@NonNull WebViewModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configure();
    }

    private void configure() {
        this.environment.lifecycle().addObserver(this.lifecycleListener);
        this.setChromeClient(this.environment.webChromeClientFactory().create());
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.loadWebView(this.model);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void loadWebView(final @NonNull WebViewModel model) {
        this.webView = new AirshipWebView(this.getContext());
        Bundle savedState = model.getSavedState();
        if (savedState != null) {
            this.webView.restoreState(savedState);
        }
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout.LayoutParams webViewLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        webViewLayoutParams.gravity = 17;
        frameLayout.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLayoutParams);
        final ProgressBar progressBar = new ProgressBar(this.getContext());
        progressBar.setIndeterminate(true);
        progressBar.setId(16908301);
        FrameLayout.LayoutParams progressBarLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        progressBarLayoutParams.gravity = 17;
        frameLayout.addView((View)progressBar, (ViewGroup.LayoutParams)progressBarLayoutParams);
        WebSettings settings = this.webView.getSettings();
        settings.setJavaScriptEnabled(true);
        if (ManifestUtils.shouldEnableLocalStorage()) {
            settings.setDomStorageEnabled(true);
            settings.setDatabaseEnabled(true);
        }
        AirshipWebViewClient client = this.environment.webViewClientFactory().create();
        client.addListener((AirshipWebViewClient.Listener)new ClientListener(){

            @Override
            protected void onPageFinished(@NonNull WebView webView) {
                webView.setVisibility(0);
                progressBar.setVisibility(8);
            }

            @Override
            protected void onRetry(@NonNull WebView webView) {
                webView.loadUrl(model.getUrl());
            }

            public boolean onClose(@NonNull WebView webView) {
                model.onClose();
                return true;
            }
        });
        this.webView.setWebChromeClient(this.chromeClient);
        this.webView.setVisibility(4);
        this.webView.setWebViewClient((WebViewClient)client);
        this.addView((View)frameLayout);
        if (!UAirship.shared().getUrlAllowList().isAllowed(model.getUrl(), 2)) {
            Logger.error((String)"URL not allowed. Unable to load: %s", (Object[])new Object[]{model.getUrl()});
            return;
        }
        if (savedState == null) {
            this.webView.loadUrl(model.getUrl());
        }
    }

    private static abstract class ClientListener
    implements AirshipWebViewClient.Listener {
        static final long START_RETRY_DELAY = 1000L;
        boolean error = false;
        long retryDelay = 1000L;

        private ClientListener() {
        }

        public void onPageFinished(@NonNull WebView view, @Nullable String url) {
            if (this.error) {
                WeakReference<WebView> webViewWeakReference = new WeakReference<WebView>(view);
                view.postDelayed(() -> {
                    WebView webView = (WebView)webViewWeakReference.get();
                    if (webView != null) {
                        this.onRetry(webView);
                    }
                }, this.retryDelay);
                this.retryDelay *= 2L;
            } else {
                this.onPageFinished(view);
            }
            this.error = false;
        }

        public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
            if (Build.VERSION.SDK_INT >= 23) {
                Logger.error((String)"Error loading web view! %d - %s", (Object[])new Object[]{error.getErrorCode(), error.getDescription()});
            } else {
                Logger.error((String)"Error loading web view!", (Object[])new Object[0]);
            }
            this.error = true;
        }

        protected abstract void onPageFinished(@NonNull WebView var1);

        protected abstract void onRetry(@NonNull WebView var1);
    }
}

