/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.CheckableModel;
import com.urbanairship.android.layout.property.CheckboxStyle;
import com.urbanairship.android.layout.property.SwitchStyle;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.CheckableViewAdapter;
import com.urbanairship.android.layout.widget.ShapeButton;
import com.urbanairship.util.UAStringUtil;

public abstract class CheckableView<M extends CheckableModel>
extends FrameLayout
implements BaseView<M> {
    @Dimension(unit=0)
    private static final int CHECKBOX_MIN_DIMENSION = 24;
    @Dimension(unit=0)
    private static final int SWITCH_MIN_HEIGHT = 24;
    @Dimension(unit=0)
    private static final int SWITCH_MIN_WIDTH = 48;
    private static final int NO_MIN_SIZE = -1;
    private M model;
    private Environment environment;
    private CheckableViewAdapter<?> view = null;
    protected final CheckableViewAdapter.OnCheckedChangeListener checkedChangeListener = (v, isChecked) -> ((CheckableModel)this.model).onCheckedChange(isChecked);

    public CheckableView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public CheckableView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CheckableView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    protected int getMinWidth() {
        switch (((CheckableModel)this.model).getToggleType()) {
            case CHECKBOX: {
                return 24;
            }
            case SWITCH: {
                return 48;
            }
        }
        return -1;
    }

    protected int getMinHeight() {
        switch (((CheckableModel)this.model).getToggleType()) {
            case CHECKBOX: {
                return 24;
            }
            case SWITCH: {
                return 24;
            }
        }
        return -1;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidthDp = this.getMinWidth();
        int minHeightDp = this.getMinHeight();
        if (minWidthDp == -1 && minHeightDp == -1) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int widthSpec = widthMeasureSpec;
            int heightSpec = heightMeasureSpec;
            if (minWidthDp != -1) {
                int minWidth = (int)ResourceUtils.dpToPx(this.getContext(), minWidthDp);
                if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
                    widthSpec = View.MeasureSpec.makeMeasureSpec((int)minWidth, (int)0x40000000);
                }
            }
            if (minHeightDp != -1) {
                int minHeight = (int)ResourceUtils.dpToPx(this.getContext(), minHeightDp);
                if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)minHeight, (int)0x40000000);
                }
            }
            super.onMeasure(widthSpec, heightSpec);
        }
    }

    @Override
    public void setModel(@NonNull M model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(((BaseModel)model).getViewId());
        this.configure();
    }

    protected M getModel() {
        return this.model;
    }

    protected Environment environment() {
        return this.environment;
    }

    public CheckableViewAdapter<?> getCheckableView() {
        return this.view;
    }

    protected void configure() {
        switch (((CheckableModel)this.model).getToggleType()) {
            case SWITCH: {
                this.configureSwitch((SwitchStyle)((CheckableModel)this.model).getStyle());
                break;
            }
            case CHECKBOX: {
                this.configureCheckbox((CheckboxStyle)((CheckableModel)this.model).getStyle());
            }
        }
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        if (!UAStringUtil.isEmpty((String)((CheckableModel)this.model).getContentDescription())) {
            this.view.setContentDescription(((CheckableModel)this.model).getContentDescription());
        }
        ((CheckableModel)this.model).onConfigured();
        LayoutUtils.doOnAttachToWindow((View)this, () -> this.model.onAttachedToWindow());
    }

    protected void configureSwitch(SwitchStyle style) {
        SwitchCompat switchView = this.createSwitchView(style);
        switchView.setId(((CheckableModel)this.model).getCheckableViewId());
        LayoutUtils.applySwitchStyle(switchView, style);
        this.view = new CheckableViewAdapter.Switch(switchView);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        lp.topMargin = -3;
        this.addView((View)switchView, (ViewGroup.LayoutParams)lp);
    }

    protected void configureCheckbox(CheckboxStyle style) {
        ShapeButton checkboxView = this.createCheckboxView(style);
        checkboxView.setId(((CheckableModel)this.model).getCheckableViewId());
        LayoutUtils.applyBorderAndBackground((View)checkboxView, this.model);
        this.view = new CheckableViewAdapter.Checkbox(checkboxView);
        this.addView((View)checkboxView, -1, -1);
    }

    @NonNull
    protected SwitchCompat createSwitchView(SwitchStyle style) {
        return new SwitchCompat(this.getContext());
    }

    @NonNull
    protected ShapeButton createCheckboxView(CheckboxStyle style) {
        CheckboxStyle.Binding checked = style.getBindings().getSelected();
        CheckboxStyle.Binding unchecked = style.getBindings().getUnselected();
        return new ShapeButton(this.getContext(), checked.getShapes(), unchecked.getShapes(), checked.getIcon(), unchecked.getIcon());
    }

    protected void setCheckedInternal(boolean isChecked) {
        this.view.setOnCheckedChangeListener(null);
        this.view.setChecked(isChecked);
        this.view.setOnCheckedChangeListener(this.checkedChangeListener);
    }
}

