/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.android.layout.widget.PagerAdapter;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PagerRecyclerView
extends RecyclerView {
    private PagerModel model;
    private Environment environment;
    private PagerAdapter adapter;
    private LinearLayoutManager layoutManager;
    private PagerSnapHelper snapHelper;
    private boolean isInternalScroll = false;
    private final RecyclerView.OnScrollListener recyclerScrollListener = new RecyclerView.OnScrollListener(){
        private int previousPosition = 0;

        public void onScrollStateChanged(@NonNull RecyclerView v, int state) {
            if (state != 0) {
                return;
            }
            int position = PagerRecyclerView.this.getDisplayedItemPosition();
            if (position != -1 && position != this.previousPosition) {
                int step = position > this.previousPosition ? 1 : -1;
                int distance = Math.abs(position - this.previousPosition);
                for (int i = 0; i < distance; ++i) {
                    int calculated = this.previousPosition + step * (i + 1);
                    PagerRecyclerView.this.model.onScrollTo(calculated, PagerRecyclerView.this.isInternalScroll, PagerRecyclerView.this.environment.displayTimer().getTime());
                }
            }
            this.previousPosition = position;
            PagerRecyclerView.this.isInternalScroll = false;
        }
    };

    public PagerRecyclerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.snapHelper = new SnapHelper();
        this.snapHelper.attachToRecyclerView((RecyclerView)this);
        this.setHorizontalScrollBarEnabled(false);
    }

    public void configure(@NonNull PagerModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getRecyclerViewId());
        Consumer onLayoutComplete = isInitialLayout -> {
            if (!isInitialLayout.booleanValue()) {
                return;
            }
            model.onConfigured(this.getDisplayedItemPosition(), environment.displayTimer().getTime());
        };
        this.layoutManager = model.getChildren().size() <= 1 || model.isSwipeDisabled() ? new SwipeDisabledLinearLayoutManager(this.getContext(), 0, (Consumer<Boolean>)onLayoutComplete) : new ThomasLinearLayoutManager(this.getContext(), 0, (Consumer<Boolean>)onLayoutComplete);
        this.layoutManager.setItemPrefetchEnabled(false);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.addOnScrollListener(this.recyclerScrollListener);
        this.adapter = new PagerAdapter(model, environment);
        this.adapter.setStateRestorationPolicy(RecyclerView.Adapter.StateRestorationPolicy.PREVENT_WHEN_EMPTY);
        this.adapter.setItems(model.getChildren());
        this.setAdapter(this.adapter);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (v, insets) -> {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewCompat.dispatchApplyWindowInsets((View)this.getChildAt(i), (WindowInsetsCompat)insets);
            }
            return insets;
        });
    }

    public int getDisplayedItemPosition() {
        View snapView = this.snapHelper.findSnapView((RecyclerView.LayoutManager)this.layoutManager);
        return snapView != null ? this.getChildAdapterPosition(snapView) : 0;
    }

    public int getAdapterItemCount() {
        return this.adapter.getItemCount();
    }

    public void scrollTo(int position) {
        this.isInternalScroll = true;
        this.smoothScrollToPosition(position);
    }

    private static class SnapHelper
    extends PagerSnapHelper {
        @Nullable
        private OrientationHelper verticalHelper;
        @Nullable
        private OrientationHelper horizontalHelper;

        private SnapHelper() {
        }

        @Nullable
        public View findSnapView(RecyclerView.LayoutManager layoutManager) {
            if (layoutManager.getLayoutDirection() == 1) {
                return this.findCenterView(layoutManager, this.getVerticalHelper(layoutManager));
            }
            return this.findCenterView(layoutManager, this.getHorizontalHelper(layoutManager));
        }

        @Nullable
        private View findCenterView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
            int childCount = layoutManager.getChildCount();
            if (childCount == 0) {
                return null;
            }
            View closestChild = null;
            int center = helper.getStartAfterPadding() + helper.getTotalSpace() / 2;
            int absClosest = Integer.MAX_VALUE;
            for (int i = 0; i < childCount; ++i) {
                View child = layoutManager.getChildAt(i);
                int childCenter = helper.getDecoratedStart(child) + helper.getDecoratedMeasurement(child) / 2;
                int absDistance = Math.abs(childCenter - center);
                if (absDistance >= absClosest) continue;
                absClosest = absDistance;
                closestChild = child;
            }
            return closestChild;
        }

        @NonNull
        private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
            if (this.verticalHelper == null || this.verticalHelper.getLayoutManager() != layoutManager) {
                this.verticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
            }
            return this.verticalHelper;
        }

        @NonNull
        private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
            if (this.horizontalHelper == null || this.horizontalHelper.getLayoutManager() != layoutManager) {
                this.horizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
            }
            return this.horizontalHelper;
        }
    }

    private static class SwipeDisabledLinearLayoutManager
    extends ThomasLinearLayoutManager {
        public SwipeDisabledLinearLayoutManager(Context context, int orientation, Consumer<Boolean> completedCallback) {
            super(context, orientation, completedCallback);
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            SwipeDisabledSmoothScroller smoothScroller = new SwipeDisabledSmoothScroller(recyclerView.getContext());
            smoothScroller.setTargetPosition(position);
            this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
        }

        private static class SwipeDisabledSmoothScroller
        extends LinearSmoothScroller {
            public SwipeDisabledSmoothScroller(Context context) {
                super(context);
            }

            public int calculateDxToMakeVisible(View view, int snapPreference) {
                RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
                if (layoutManager == null) {
                    return 0;
                }
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                int left = layoutManager.getDecoratedLeft(view) - params.leftMargin;
                int right = layoutManager.getDecoratedRight(view) + params.rightMargin;
                int start = layoutManager.getPaddingLeft();
                int end = layoutManager.getWidth() - layoutManager.getPaddingRight();
                return this.calculateDtToFit(left, right, start, end, snapPreference);
            }
        }
    }

    private static class ThomasLinearLayoutManager
    extends LinearLayoutManager {
        private final Consumer<Boolean> layoutCompletedCallback;
        private boolean isInitialLayout = true;

        public ThomasLinearLayoutManager(Context context, int orientation, Consumer<Boolean> completedCallback) {
            super(context, orientation, false);
            this.layoutCompletedCallback = completedCallback;
        }

        public void onLayoutCompleted(RecyclerView.State state) {
            super.onLayoutCompleted(state);
            this.layoutCompletedCallback.accept((Object)this.isInitialLayout);
            this.isInitialLayout = false;
        }
    }
}

