/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.shape.Shape;
import com.urbanairship.android.layout.widget.DrawableWrapper;

public class ShapeDrawableWrapper
extends DrawableWrapper {
    private final ShapeState state;
    private final Rect tempRect = new Rect();

    public ShapeDrawableWrapper(@NonNull Context context, @NonNull Shape shape) {
        this(shape.getDrawable(context), shape.getAspectRatio(), shape.getScale());
    }

    public ShapeDrawableWrapper(@NonNull Drawable drawable2, float aspectRatio, float scale) {
        this(new ShapeState(null), null);
        this.state.aspectRatio = aspectRatio;
        this.state.scale = scale;
        this.setDrawable(drawable2);
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        int height;
        int width;
        Rect r = this.tempRect;
        r.set(bounds);
        if (this.state.aspectRatio == 1.0f) {
            int minDimension;
            width = minDimension = Math.min(bounds.width(), bounds.height());
            height = minDimension;
        } else if (this.state.aspectRatio > 1.0f) {
            width = bounds.width();
            height = (int)((float)bounds.height() / this.state.aspectRatio);
        } else {
            width = (int)((float)bounds.width() * this.state.aspectRatio);
            height = bounds.height();
        }
        width = (int)((float)width * this.state.scale);
        height = (int)((float)height * this.state.scale);
        int widthDiff = (bounds.width() - width) / 2;
        int heightDiff = (bounds.height() - height) / 2;
        r.left += widthDiff;
        r.right -= widthDiff;
        r.top += heightDiff;
        r.bottom -= heightDiff;
        super.onBoundsChange(r);
    }

    @Override
    public int getIntrinsicWidth() {
        return -1;
    }

    @Override
    public int getIntrinsicHeight() {
        return -1;
    }

    public final Drawable.ConstantState getConstantState() {
        this.state.isChangingConfigurations |= this.getChangingConfigurations();
        return this.state;
    }

    private ShapeDrawableWrapper(@Nullable ShapeState state, @Nullable Resources res) {
        super(state, res);
        this.state = state;
        this.updateLocalState();
    }

    private void updateLocalState() {
        if (this.state != null && this.state.cachedDrawable != null) {
            this.setDrawable(this.state.cachedDrawable);
        }
    }

    static final class ShapeState
    extends DrawableWrapper.DrawableWrapperState {
        int isChangingConfigurations;
        Drawable.ConstantState drawableState;
        Drawable cachedDrawable;
        float scale;
        float aspectRatio;

        ShapeState(@Nullable ShapeState orig) {
            super(orig, null);
            if (orig != null) {
                this.isChangingConfigurations = orig.isChangingConfigurations;
                this.drawableState = orig.drawableState;
                this.cachedDrawable = orig.cachedDrawable;
                this.scale = orig.scale;
                this.aspectRatio = orig.aspectRatio;
            }
        }

        @Override
        @NonNull
        public Drawable newDrawable(@Nullable Resources res) {
            return new ShapeDrawableWrapper(this, res);
        }
    }
}

