/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.event;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.event.EventType;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonValue;
import java.util.Map;

public abstract class Event {
    @NonNull
    private final EventType type;

    protected Event(@NonNull EventType type) {
        this.type = type;
    }

    public String toString() {
        return "Event{type=" + (Object)((Object)this.type) + '}';
    }

    @NonNull
    public EventType getType() {
        return this.type;
    }

    public static interface EventWithActions {
        @NonNull
        public Map<String, JsonValue> getActions();
    }

    public static class ViewAttachedToWindow
    extends Event {
        private final BaseModel model;

        public ViewAttachedToWindow(@NonNull BaseModel model) {
            super(EventType.VIEW_ATTACHED);
            this.model = model;
        }

        public ViewType getViewType() {
            return this.model.getType();
        }

        public BaseModel getModel() {
            return this.model;
        }

        @Override
        @NonNull
        public String toString() {
            return "ViewAttachedToWindow{, viewType=" + (Object)((Object)this.getViewType()) + ", model=" + this.model + '}';
        }
    }

    public static class ViewInit
    extends Event {
        private final BaseModel model;

        public ViewInit(@NonNull BaseModel model) {
            super(EventType.VIEW_INIT);
            this.model = model;
        }

        public ViewType getViewType() {
            return this.model.getType();
        }

        public BaseModel getModel() {
            return this.model;
        }

        @Override
        @NonNull
        public String toString() {
            return "ViewInit{, viewType=" + (Object)((Object)this.getViewType()) + ", model=" + this.model + '}';
        }
    }
}

