/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.event;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventType;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.Map;

public abstract class PagerEvent
extends Event {
    private final long time;
    @NonNull
    private final Map<String, JsonValue> pageActions;

    public PagerEvent(@NonNull EventType type, long time, @NonNull Map<String, JsonValue> pageActions) {
        super(type);
        this.time = time;
        this.pageActions = pageActions;
    }

    public long getTime() {
        return this.time;
    }

    @NonNull
    public Map<String, JsonValue> getPageActions() {
        return this.pageActions;
    }

    public boolean hasPageActions() {
        return !this.pageActions.isEmpty();
    }

    public static final class PageActions
    extends Event
    implements Event.EventWithActions {
        @NonNull
        private final Map<String, JsonValue> actions;

        public PageActions(@NonNull Map<String, JsonValue> actions) {
            super(EventType.PAGER_PAGE_ACTIONS);
            this.actions = actions;
        }

        @Override
        @NonNull
        public Map<String, JsonValue> getActions() {
            return this.actions;
        }

        @Override
        @NonNull
        public String toString() {
            return "PageActions{actions='" + new JsonMap(this.actions) + '\'' + '}';
        }
    }

    public static final class Scroll
    extends PagerEvent {
        private final int pageIndex;
        @NonNull
        private final String pageId;
        private final int previousPageIndex;
        @NonNull
        private final String previousPageId;
        private final boolean hasNext;
        private final boolean hasPrev;
        private final boolean isInternalScroll;

        public Scroll(@NonNull PagerModel model, int pageIndex, @NonNull String pageId, @NonNull Map<String, JsonValue> pageActions, int previousPageIndex, @NonNull String previousPageId, boolean isInternalScroll, long time) {
            super(EventType.PAGER_SCROLL, time, pageActions);
            this.pageIndex = pageIndex;
            this.pageId = pageId;
            this.previousPageIndex = previousPageIndex;
            this.previousPageId = previousPageId;
            this.hasNext = pageIndex < model.getItems().size() - 1;
            this.hasPrev = pageIndex > 0;
            this.isInternalScroll = isInternalScroll;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public int getPreviousPageIndex() {
            return this.previousPageIndex;
        }

        @NonNull
        public String getPageId() {
            return this.pageId;
        }

        @NonNull
        public String getPreviousPageId() {
            return this.previousPageId;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public boolean hasPrevious() {
            return this.hasPrev;
        }

        public boolean isInternal() {
            return this.isInternalScroll;
        }

        @Override
        @NonNull
        public String toString() {
            return "Scroll{pageIndex=" + this.pageIndex + ", pageId='" + this.pageId + '\'' + ", previousPageIndex=" + this.previousPageIndex + ", previousPageId='" + this.previousPageId + '\'' + ", hasNext=" + this.hasNext + ", hasPrev=" + this.hasPrev + ", isInternalScroll=" + this.isInternalScroll + '}';
        }
    }

    public static final class IndicatorInit
    extends Event.ViewInit {
        public IndicatorInit(@NonNull BaseModel model) {
            super(model);
        }

        @Override
        @NonNull
        public String toString() {
            return "PagerEvent.IndicatorInit{}";
        }
    }

    public static final class Init
    extends PagerEvent {
        private final int size;
        private final int pageIndex;
        @NonNull
        private final String pageId;
        private final boolean hasNext;
        private final boolean hasPrev;

        public Init(@NonNull PagerModel model, int pageIndex, @NonNull String pageId, @NonNull Map<String, JsonValue> pageActions, long time) {
            super(EventType.PAGER_INIT, time, pageActions);
            this.size = model.getItems().size();
            this.pageIndex = pageIndex;
            this.pageId = pageId;
            this.hasNext = pageIndex < this.size - 1;
            this.hasPrev = pageIndex > 0;
        }

        public int getSize() {
            return this.size;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        @NonNull
        public String getPageId() {
            return this.pageId;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public boolean hasPrevious() {
            return this.hasPrev;
        }

        @Override
        @NonNull
        public String toString() {
            return "Init{size=" + this.size + ", pageIndex=" + this.pageIndex + ", pageId='" + this.pageId + '\'' + ", hasNext=" + this.hasNext + ", hasPrev=" + this.hasPrev + '}';
        }
    }
}

