/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.event.ButtonEvent;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.PagerEvent;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.ButtonClickBehaviorType;
import com.urbanairship.android.layout.property.ButtonEnableBehaviorType;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.List;
import java.util.Map;

public abstract class ButtonModel
extends BaseModel
implements Accessible,
Identifiable {
    @NonNull
    private final String identifier;
    @NonNull
    private final List<ButtonClickBehaviorType> buttonClickBehaviors;
    @NonNull
    private final Map<String, JsonValue> actions;
    @NonNull
    private final List<ButtonEnableBehaviorType> enableBehaviors;
    @Nullable
    private final String contentDescription;
    @Nullable
    private Listener viewListener = null;
    private boolean isEnabled = true;

    protected ButtonModel(@NonNull ViewType type, @NonNull String identifier, @NonNull List<ButtonClickBehaviorType> buttonClickBehaviors, @NonNull Map<String, JsonValue> actions, @NonNull List<ButtonEnableBehaviorType> enableBehaviors, @Nullable Color backgroundColor, @Nullable Border border, @Nullable String contentDescription) {
        super(type, backgroundColor, border);
        this.identifier = identifier;
        this.buttonClickBehaviors = buttonClickBehaviors;
        this.actions = actions;
        this.enableBehaviors = enableBehaviors;
        this.contentDescription = contentDescription;
    }

    public static List<ButtonClickBehaviorType> buttonClickBehaviorsFromJson(@NonNull JsonMap json) throws JsonException {
        JsonList clickBehaviorsList = json.opt("button_click").optList();
        return ButtonClickBehaviorType.fromList(clickBehaviorsList);
    }

    public static Map<String, JsonValue> actionsFromJson(@NonNull JsonMap json) {
        return json.opt("actions").optMap().getMap();
    }

    public static List<ButtonEnableBehaviorType> buttonEnableBehaviorsFromJson(@NonNull JsonMap json) throws JsonException {
        JsonList enableBehaviorsList = json.opt("enabled").optList();
        return ButtonEnableBehaviorType.fromList(enableBehaviorsList);
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @NonNull
    public Map<String, JsonValue> getActions() {
        return this.actions;
    }

    public void setViewListener(@Nullable Listener viewListener) {
        this.viewListener = viewListener;
        if (viewListener != null) {
            viewListener.setEnabled(this.isEnabled());
        }
    }

    private boolean hasActions() {
        return this.actions.size() > 0;
    }

    private boolean isEnabled() {
        return this.enableBehaviors.isEmpty() || this.isEnabled;
    }

    public void onClick() {
        LayoutData layoutData = LayoutData.button(this.identifier);
        this.bubbleEvent(new ReportingEvent.ButtonTap(this.identifier), layoutData);
        if (this.hasActions()) {
            this.bubbleEvent(new ButtonEvent.Actions(this), layoutData);
        }
        for (ButtonClickBehaviorType behavior : this.buttonClickBehaviors) {
            try {
                this.bubbleEvent(ButtonEvent.fromBehavior(behavior, this), layoutData);
            }
            catch (JsonException e) {
                Logger.warn((Throwable)e, (String)"Skipping button click behavior!", (Object[])new Object[0]);
            }
        }
    }

    @NonNull
    public abstract String reportingDescription();

    @Override
    public boolean onEvent(@NonNull Event event, @NonNull LayoutData layoutData) {
        switch (event.getType()) {
            case FORM_VALIDATION: {
                return this.handleFormSubmitUpdate((FormEvent.ValidationUpdate)event);
            }
            case PAGER_INIT: {
                PagerEvent.Init init = (PagerEvent.Init)event;
                return this.handlePagerScroll(init.hasNext(), init.hasPrevious());
            }
            case PAGER_SCROLL: {
                PagerEvent.Scroll scroll = (PagerEvent.Scroll)event;
                return this.handlePagerScroll(scroll.hasNext(), scroll.hasPrevious());
            }
        }
        return super.onEvent(event, layoutData);
    }

    private boolean handleFormSubmitUpdate(FormEvent.ValidationUpdate update) {
        if (this.enableBehaviors.contains((Object)ButtonEnableBehaviorType.FORM_VALIDATION)) {
            this.isEnabled = update.isValid();
            if (this.viewListener != null) {
                this.viewListener.setEnabled(update.isValid());
            }
            return true;
        }
        return false;
    }

    private boolean handlePagerScroll(boolean hasNext, boolean hasPrevious) {
        if (this.enableBehaviors.contains((Object)ButtonEnableBehaviorType.PAGER_NEXT)) {
            this.isEnabled = hasNext;
            if (this.viewListener != null) {
                this.viewListener.setEnabled(hasNext);
            }
        }
        if (this.enableBehaviors.contains((Object)ButtonEnableBehaviorType.PAGER_PREVIOUS)) {
            this.isEnabled = hasPrevious;
            if (this.viewListener != null) {
                this.viewListener.setEnabled(hasPrevious);
            }
        }
        return false;
    }

    public static interface Listener {
        public void setEnabled(boolean var1);
    }
}

