/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ToggleType;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public abstract class CheckableModel
extends BaseModel
implements Accessible {
    @NonNull
    private final ToggleStyle style;
    @Nullable
    private final String contentDescription;
    @Nullable
    private Listener listener = null;
    private final int checkableViewId = View.generateViewId();

    public CheckableModel(@NonNull ViewType viewType, @NonNull ToggleStyle style, @Nullable String contentDescription, @Nullable Color backgroundColor, @Nullable Border border) {
        super(viewType, backgroundColor, border);
        this.style = style;
        this.contentDescription = contentDescription;
    }

    @NonNull
    protected static ToggleStyle toggleStyleFromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap styleJson = json.opt("style").optMap();
        return ToggleStyle.fromJson(styleJson);
    }

    @NonNull
    public ToggleStyle getStyle() {
        return this.style;
    }

    @NonNull
    public ToggleType getToggleType() {
        return this.style.getType();
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    public int getCheckableViewId() {
        return this.checkableViewId;
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void setChecked(boolean isChecked) {
        if (this.listener != null) {
            this.listener.onSetChecked(isChecked);
        }
    }

    @CallSuper
    public void onConfigured() {
        this.bubbleEvent(this.buildInitEvent(), LayoutData.empty());
    }

    public void onAttachedToWindow() {
        this.bubbleEvent(new Event.ViewAttachedToWindow(this), LayoutData.empty());
    }

    public void onCheckedChange(boolean isChecked) {
        this.bubbleEvent(this.buildInputChangeEvent(isChecked), LayoutData.empty());
    }

    @NonNull
    public abstract Event buildInputChangeEvent(boolean var1);

    @NonNull
    public abstract Event buildInitEvent();

    public static interface Listener {
        public void onSetChecked(boolean var1);
    }
}

