/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.event.CheckboxEvent;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.CheckboxModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.model.Validatable;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CheckboxController
extends LayoutModel
implements Identifiable,
Accessible,
Validatable {
    @NonNull
    private final String identifier;
    @NonNull
    private final BaseModel view;
    private final int minSelection;
    private final int maxSelection;
    private final boolean isRequired;
    @Nullable
    private final String contentDescription;
    @NonNull
    private final List<CheckboxModel> checkboxes = new ArrayList<CheckboxModel>();
    private final Set<JsonValue> selectedValues = new HashSet<JsonValue>();

    public CheckboxController(@NonNull String identifier, @NonNull BaseModel view, int minSelection, int maxSelection, boolean isRequired, @Nullable String contentDescription) {
        super(ViewType.CHECKBOX_CONTROLLER, null, null);
        this.identifier = identifier;
        this.view = view;
        this.minSelection = minSelection;
        this.maxSelection = maxSelection;
        this.isRequired = isRequired;
        this.contentDescription = contentDescription;
        view.addListener(this);
    }

    @NonNull
    public static CheckboxController fromJson(@NonNull JsonMap json) throws JsonException {
        String identifier = Identifiable.identifierFromJson(json);
        JsonMap viewJson = json.opt("view").optMap();
        boolean isRequired = Validatable.requiredFromJson(json);
        int minSelection = json.opt("min_selection").getInt(isRequired ? 1 : 0);
        int maxSelection = json.opt("max_selection").getInt(Integer.MAX_VALUE);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        BaseModel view = Thomas.model(viewJson);
        return new CheckboxController(identifier, view, minSelection, maxSelection, isRequired, contentDescription);
    }

    @Override
    public List<BaseModel> getChildren() {
        return Collections.singletonList(this.view);
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @NonNull
    public BaseModel getView() {
        return this.view;
    }

    @Override
    public boolean isValid() {
        int count = this.selectedValues.size();
        boolean isFilled = count >= this.minSelection && count <= this.maxSelection;
        boolean isOptional = count == 0 && !this.isRequired;
        return isFilled || isOptional;
    }

    @NonNull
    @VisibleForTesting
    public List<CheckboxModel> getCheckboxes() {
        return this.checkboxes;
    }

    @NonNull
    @VisibleForTesting
    public Set<JsonValue> getSelectedValues() {
        return this.selectedValues;
    }

    @Override
    public boolean onEvent(@NonNull Event event, @NonNull LayoutData layoutData) {
        switch (event.getType()) {
            case VIEW_INIT: {
                return this.onViewInit((Event.ViewInit)event, layoutData);
            }
            case CHECKBOX_INPUT_CHANGE: {
                return this.onCheckboxInputChange((CheckboxEvent.InputChange)event, layoutData);
            }
            case VIEW_ATTACHED: {
                return this.onViewAttached((Event.ViewAttachedToWindow)event, layoutData);
            }
        }
        return super.onEvent(event, layoutData);
    }

    private boolean onViewInit(Event.ViewInit event, @NonNull LayoutData layoutData) {
        if (event.getViewType() == ViewType.CHECKBOX) {
            CheckboxModel model;
            if (this.checkboxes.isEmpty()) {
                this.bubbleEvent(new CheckboxEvent.ControllerInit(this.identifier, this.isValid()), layoutData);
            }
            if (!this.checkboxes.contains(model = (CheckboxModel)event.getModel())) {
                this.checkboxes.add(model);
            }
            return true;
        }
        return false;
    }

    private boolean onCheckboxInputChange(@NonNull CheckboxEvent.InputChange event, @NonNull LayoutData layoutData) {
        if (event.isChecked() && this.selectedValues.size() + 1 > this.maxSelection) {
            Logger.debug((String)"Ignoring checkbox input change for '%s'. Max selections reached!", (Object[])new Object[]{event.getValue()});
            return true;
        }
        if (event.isChecked()) {
            this.selectedValues.add((JsonValue)event.getValue());
        } else {
            this.selectedValues.remove(event.getValue());
        }
        this.trickleEvent(new CheckboxEvent.ViewUpdate((JsonValue)event.getValue(), event.isChecked()), layoutData);
        this.bubbleEvent(new FormEvent.DataChange(new FormData.CheckboxController(this.identifier, this.selectedValues), this.isValid()), layoutData);
        return true;
    }

    private boolean onViewAttached(@NonNull Event.ViewAttachedToWindow event, @NonNull LayoutData layoutData) {
        if (event.getViewType() == ViewType.CHECKBOX && event.getModel() instanceof CheckboxModel && !this.selectedValues.isEmpty()) {
            CheckboxModel model = (CheckboxModel)event.getModel();
            boolean isChecked = this.selectedValues.contains(model.getReportingValue());
            this.trickleEvent(new CheckboxEvent.ViewUpdate(model.getReportingValue(), isChecked), layoutData);
        }
        return super.onEvent(event, layoutData);
    }
}

