/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.CheckboxEvent;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.CheckableModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;

public class CheckboxModel
extends CheckableModel {
    @NonNull
    private final JsonValue reportingValue;

    public CheckboxModel(@NonNull JsonValue reportingValue, @NonNull ToggleStyle style, @Nullable String contentDescription, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.CHECKBOX, style, contentDescription, backgroundColor, border);
        this.reportingValue = reportingValue;
    }

    @NonNull
    public static CheckboxModel fromJson(@NonNull JsonMap json) throws JsonException {
        JsonValue reportingValue = json.opt("reporting_value").toJsonValue();
        ToggleStyle style = CheckboxModel.toggleStyleFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        Color backgroundColor = CheckboxModel.backgroundColorFromJson(json);
        Border border = CheckboxModel.borderFromJson(json);
        return new CheckboxModel(reportingValue, style, contentDescription, backgroundColor, border);
    }

    @NonNull
    public JsonValue getReportingValue() {
        return this.reportingValue;
    }

    @Override
    @NonNull
    public Event buildInputChangeEvent(boolean isChecked) {
        return new CheckboxEvent.InputChange(this.reportingValue, isChecked);
    }

    @Override
    @NonNull
    public Event buildInitEvent() {
        return new Event.ViewInit(this);
    }

    @Override
    public boolean onEvent(@NonNull Event event, @NonNull LayoutData layoutData) {
        switch (event.getType()) {
            case CHECKBOX_VIEW_UPDATE: {
                CheckboxEvent.ViewUpdate update = (CheckboxEvent.ViewUpdate)event;
                if (this.reportingValue.equals(update.getValue())) {
                    this.setChecked(update.isChecked());
                }
                return false;
            }
        }
        return super.onEvent(event, layoutData);
    }
}

