/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.model.BaseFormController;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.FormBehaviorType;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class FormController
extends BaseFormController {
    public FormController(@NonNull String identifier, @Nullable String responseType, @NonNull BaseModel view, @Nullable FormBehaviorType submitBehavior) {
        super(ViewType.FORM_CONTROLLER, identifier, responseType, view, submitBehavior);
    }

    @NonNull
    public static FormController fromJson(@NonNull JsonMap json) throws JsonException {
        String identifier = FormController.identifierFromJson(json);
        BaseModel view = FormController.viewFromJson(json);
        FormBehaviorType submitBehavior = FormController.submitBehaviorFromJson(json);
        String responseType = json.opt("response_type").getString();
        return new FormController(identifier, responseType, view, submitBehavior);
    }

    @Override
    protected FormEvent.Init getInitEvent() {
        return new FormEvent.Init(this.getIdentifier(), this.isFormValid());
    }

    @Override
    protected FormEvent.DataChange getFormDataChangeEvent() {
        return new FormEvent.DataChange(new FormData.Form(this.getIdentifier(), this.getResponseType(), this.getFormData()), this.isFormValid());
    }

    @Override
    protected ReportingEvent.FormResult getFormResultEvent() {
        return new ReportingEvent.FormResult(new FormData.Form(this.getIdentifier(), this.getResponseType(), this.getFormData()), this.getFormInfo(), this.getAttributes());
    }

    @Override
    @NonNull
    protected String getFormType() {
        return "form";
    }
}

