/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.ButtonModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.ButtonClickBehaviorType;
import com.urbanairship.android.layout.property.ButtonEnableBehaviorType;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.List;
import java.util.Map;

public class ImageButtonModel
extends ButtonModel {
    @NonNull
    private final Image image;

    public ImageButtonModel(@NonNull String id2, @NonNull Image image, @NonNull List<ButtonClickBehaviorType> clickBehaviors, @NonNull Map<String, JsonValue> actions, @NonNull List<ButtonEnableBehaviorType> enableBehaviors, @Nullable Color backgroundColor, @Nullable Border border, @Nullable String contentDescription) {
        super(ViewType.IMAGE_BUTTON, id2, clickBehaviors, actions, enableBehaviors, backgroundColor, border, contentDescription);
        this.image = image;
    }

    @NonNull
    public static ImageButtonModel fromJson(@NonNull JsonMap json) throws JsonException {
        String id2 = Identifiable.identifierFromJson(json);
        JsonMap imageJson = json.opt("image").optMap();
        Image image = Image.fromJson(imageJson);
        List<ButtonClickBehaviorType> clickBehaviors = ImageButtonModel.buttonClickBehaviorsFromJson(json);
        Map<String, JsonValue> actions = ImageButtonModel.actionsFromJson(json);
        List<ButtonEnableBehaviorType> enableBehaviors = ImageButtonModel.buttonEnableBehaviorsFromJson(json);
        Color backgroundColor = ImageButtonModel.backgroundColorFromJson(json);
        Border border = ImageButtonModel.borderFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        return new ImageButtonModel(id2, image, clickBehaviors, actions, enableBehaviors, backgroundColor, border, contentDescription);
    }

    @NonNull
    public Image getImage() {
        return this.image;
    }

    @Override
    @NonNull
    public String reportingDescription() {
        return this.getContentDescription() != null ? this.getContentDescription() : this.getIdentifier();
    }
}

